#!/bin/bash

# Arguments are:
# First revision number
let f_rv=$1
# Last revision number
let l_rv=$2

if [ "$l_rv" = "" ]; then
    # Assume only one build
    let l_rv=$f_rv+1
    let f_rv=$f_rv-1
fi

let t_rv=($f_rv+$l_rv)/2
while [ $t_rv -ne $f_rv -a $t_rv -ne $l_rv ]; do
    echo "Trying revision $t_rv"
    TDY=`date +%Y%m%d`
    rm -rf gcc-$TDY
    svn --quiet checkout -r $t_rv http://gcc.gnu.org/svn/gcc/trunk gcc-$TDY

    echo "   Building"
    mkdir -p bin_search
    cd bin_search
    build.sh s=FCtrunk NLpower7 -s "chk dst rm src gmp Tgmp mpfr mpc ppl cloog Nbin Tbin sNgccl" -V bin_search
    mv NLpower7/logs logs-r$t_rv
    cd ../

    x=`grep '#DONE' /proj/ppc/DT/labhome/edmar/build_repo/logs/bin_search`
    rm -f /proj/ppc/DT/labhome/edmar/build_repo/logs/bin_search
    if [ "$x" != "" ]; then
	# build succeed
	let f_rv=$t_rv
    else
	# build failed
	let l_rv=$t_rv
    fi
    let t_rv=($f_rv+$l_rv)/2
done
