#!/bin/bash

simulate_program () {
    # Argument is executable path

    local PROG=$1
    local SIM SIMCONFIG r1 r2 UniqueID x

    echo ARGS-SIM $PROG
    if [ ! -f $PROG ]; then
	echo "NOT FOUND $PROG"
    fi
	
    SIM=~/dt-labhome/simulators/ame_4.0.1/x86_64-linux/bin/sim-ame
    SIMCONFIG=z4
	
    r1=`echo $RANDOM`
    r2=`echo $RANDOM`
    UniqueID=vle_tmp_${r1}_${r2}
	
    # Execution
    echo "$SIM $SIMCONFIG $PROG > $UniqueID 2>&1"
    $SIM $SIMCONFIG $PROG > $UniqueID 2>&1
	
    # last 2 lines of simulation is:
    # program exit(0)
    # Sim. Loop Time: 0 Seconds; Clock Ticks: 1301; CPS 0.000
	
    # This is the program output, show it on stdout
    head -n -2 $UniqueID
	
    # Get the exit status
    x=`tail -n 2 $UniqueID | awk '{print substr($2,6,length($2)-6); exit}'`
	
    # remove tmp files if everything is ok
    [ "$x" = "0" ] && rm -f $UniqueID
	
    # Return the exit status
    echo XYZ${x}ZYX
}

###echo "ARGS $@" # Don't forget to use -v -v so you can see the output
if [ "$6" = "'test" -a "$7" = "-d" -a "$9" = "&&" ]; then
    ###echo ARGS-CMD-L ${12}
    if [ "${12}" = "mkdir" -o "${12}" = "rm" -o "${12}" = "chmod" ]; then
	shift; shift; shift; shift; shift
	###echo ARGS-EVAL eval sh -c "$*"
	eval sh -c "$*"
    elif [ "${12:0:13}" = "/tmp/runtest." ]; then
	# Simulate program
	simulate_program ${12}
    fi
elif [ "$4" = "sh" -a "$5" = "-c" ]; then
    ###echo ARGS-CMD-S ${6}
    if [ "$6" = "'chmod" -o "$6" = "'rm" ]; then
	shift; shift; shift; shift; shift
	###echo ARGS-EVAL eval sh -c "$*"
	eval sh -c "$*"
    elif [ "${6:0:6}" = "'/tmp/" ]; then
	# Simulate program
	simulate_program ${6:1}
    fi
fi
