#!/bin/bash

if [ -z "$1" ]; then
    echo "    Usage: build_arm.sh <path to source archive>"
    exit 0
fi

base_dir=`basename $1`
base_dir=${base_dir%-*}
src_ver=${base_dir##*-}

if [[ "$base_dir" =~ "4_7" ]]; then
    gcc_ver="47"
elif [[ "$base_dir" =~ "4_6" ]]; then
    gcc_ver="46"
fi

echo "Expanding $1..."
tar xjf $1
cd $base_dir/src
find . -name '*.tar.*' | xargs -I% tar -xf %
cd cloog-ppl-0.15.11 && ./autogen.sh
cd ../zlib-1.2.5 && patch -p1 < ../zlib-1.2.5.patch
cd ../../

echo "Applying patches..."

# patches common to both 4.6 and 4.7
patch -p0 < /proj/ppc/DT/labhome/build_repo/build_gnu/patches/gcc.arm_terminate_handler
patch -p0 < /proj/ppc/DT/labhome/build_repo/build_gnu/patches/newlib.arm_ewl_specs-3
patch -p0 < /proj/ppc/DT/labhome/build_repo/build_gnu/patches/gcc.arm_fslver
patch -p0 < /proj/ppc/DT/labhome/build_repo/build_gnu/patches/gcc.arm_ENGR217999_fix
patch -p0 < /proj/ppc/DT/labhome/build_repo/build_gnu/patches/bin.arm_gas_ENGR218989_fix

if [ "$gcc_ver" == "46" ]; then
    patch < /proj/ppc/DT/labhome/build_repo/build_gnu/patches/gcc.arm_build-common
    patch < /proj/ppc/DT/labhome/build_repo/build_gnu/patches/gcc.arm_build-prerequisites
    patch < /proj/ppc/DT/labhome/build_repo/build_gnu/patches/gcc.arm_build-toolchain-2012q1
    patch -p0 < /proj/ppc/DT/labhome/build_repo/build_gnu/patches/bin.arm_ld_ENGR210584_fix
fi

if [ "$gcc_ver" == "47" ]; then
    patch < /proj/ppc/DT/labhome/build_repo/build_gnu/patches/gcc.arm_build-common-$gcc_ver
    patch < /proj/ppc/DT/labhome/build_repo/build_gnu/patches/gcc.arm_build-prerequisites-$gcc_ver
    patch < /proj/ppc/DT/labhome/build_repo/build_gnu/patches/gcc.arm_build-toolchain-2013q1
fi

export JOBS=12
export PATH=/local/build_support/fake_32bit_tools:$PATH

echo "./build-prerequisites.sh > build-prerequisites.log"
./build-prerequisites.sh > build-prerequisites.log

echo "./build-toolchain.sh > build-toolchain.log"
./build-toolchain.sh > build-toolchain.log
