#!/bin/bash

# Parameters
WRKDIR=/local/nightly
TGTLIST="NLAppc64 NLAe6500 NLAe500mc NLAe600"
declare -A TGTOPTS
TGTOPTS=(
    ["NLAe500mc"]=""
    ["NLAe600"]="-FSF"
    ["NLAe500v2"]="p=ports.e500v2_support p=gcc.rm_e500v2_loops_48"
    ["NLAe5500"]="p=gcc.e6500-FSF p=gcc.enable_soft_multilib-49"
    ["NLAe6500"]="p=gcc.e6500-FSF p=gcc.enable_soft_multilib-49"
    ["NLA970"]=""
    ["NLApower7"]=""
    ["NLAppc64"]=""
)
declare -A TGTDIRS
TGTDIRS=(
    ["NLAe500mc"]="gcc-5.0.x-Ne500mc-linux"
    ["NLAe600"]="gcc-5.0.x-Ne600-linuxaltivec"
    ["NLAe500v2"]="gcc-5.0.x-Ne500v2-linux"
    ["NLAe5500"]="gcc-5.0.x-Ne5500-linux"
    ["NLAe6500"]="gcc-5.0.x-Ne6500-linux"
    ["NLA970"]="gcc-5.0.x-970-linux"
    ["NLApower7"]="gcc-5.0.x-Npower7-linux"
    ["NLAppc64"]="gcc-5.0.x-Nppc64-linux"
)
declare -A TGTCORES
TGTCORES=(
    ["NLAe500mc"]="e500mc"
    ["NLAe600"]="e600"
    ["NLAe500v2"]="e500v2"
    ["NLAe5500"]="e5500"
    ["NLAe6500"]="e6500"
    ["NLA970"]="970"
    ["NLApower7"]="power7"
    ["NLAppc64"]="ppc64"
)
declare -A TGTMLS
TGTMLS=(
    ["NLAe500mc"]="S32"
    ["NLAe600"]="S32"
    ["NLAe500v2"]="S32"
    ["NLAe5500"]="S32 S64"
    ["NLAe6500"]="S32 S64"
    ["NLA970"]="S32 S64"
    ["NLApower7"]="S32 S64"
    ["NLAppc64"]="S32 S64"
)

# Start
mkdir -p $WRKDIR/build
mkdir -p $WRKDIR/logs
cd $WRKDIR

# Step 1 - Rotate buffers
TDY=`date +%Y%m%d`
if [ -f last_build ]; then
    source last_build
    rm -rf build/opt/gcc-$LAST
    for tgt in $TGTLIST; do
	mv -f build/opt/freescale/$tgt/logs logs/${tgt}-r${LASTREV}
    done
fi

# Step 2 - Build current trunk
banner "BUILDS"
cd build
for tgt in $TGTLIST; do
    echo "====================================================="
    echo "                     $tgt"
    echo "====================================================="
    logfile=/proj/ppc/DT/labhome/b30502/build_repo/logs/nightly_$tgt
    build.sh s=FCtrunk ${TGTOPTS[$tgt]} t=DGNOBOARD $tgt -V nightly_$tgt

    x=`grep '#DONE' $logfile`
    if [ "$x" != "" ]; then
	eval BUILDOK${tgt}="Y"
	build.sh s=FCtrunk ${TGTOPTS[$tgt]} t=DGNOBOARD $tgt -s Tgcc -V nightly_$tgt
    else
	eval BUILDOK${tgt}=""
    fi
    cat $logfile
done
cd ../

# Step 3 - Record yesterday info today
cd build/opt/gcc-$TDY
REV=`svn info | grep 'Revision' | awk '{print $2}'`
cd ../../../
echo "LAST=$TDY" > last_build
echo "LASTREV=$REV" >> last_build
for tgt in $TGTLIST; do
    TI="TDYOK${tgt}"
    LI="LASTOK${tgt}"
    logfile=/proj/ppc/DT/labhome/b30502/build_repo/logs/nightly_$tgt
    x=`grep '#DONE' $logfile`
    rm $logfile
    if [ "$x" != "" ]; then
	eval TDYOK${tgt}="r${REV}"
    else
	eval TDYOK${tgt}="${!LI}"
    fi
    echo "LASTOK${tgt}=${!TI}" >> last_build
done

# Step 4 - Excute performance tests
banner "TEST"
for tgt in $TGTLIST; do
    TI="TDYOK${tgt}"
    LI="LASTOK${tgt}"
    BI="BUILDOK${tgt}"
    [ "${!BI}" = "" ] && continue
    echo "====================================================="
    echo "                     $tgt"
    echo "====================================================="
    GCC=$WRKDIR/build/opt/freescale/${TGTDIRS[$tgt]}/ppc64-linux/bin/gcc
    $GCC -v
    for (( i=0 ; i<8 ; i++ )); do
	rm -f target_log
	echo "${tgt}-r${REV}.target_log" > test.target_log
	test.sh hn=localhost tn=localhost Htools=$WRKDIR/build/opt/freescale \
	    tools=${TGTDIRS[$tgt]}/ppc64-linux prefix="" \
	    core=${TGTCORES[$tgt]} ml="${TGTMLS[$tgt]}" ct="dhrystone coremark"
	mv test.target_log test-${i}.target_log
    done
    bmksum.pl -bestof ${tgt}-r${REV} \
	test-0.target_log test-1.target_log test-2.target_log \
	test-3.target_log test-4.target_log test-5.target_log \
	test-6.target_log test-7.target_log -writebestof > /dev/null
    mv -f test.host_log test-*.target_log ${tgt}-r${REV}_best_0.target_log build/opt/freescale/$tgt/logs
done

# Step 5 - Compare results
banner "DEJAGNU"
for tgt in $TGTLIST; do
    TI="TDYOK${tgt}"
    LI="LASTOK${tgt}"
    BI="BUILDOK${tgt}"
    [ "${!BI}" = "" ] && continue
    if [ "${!TI}" = "${!LI}" ]; then
	continue
    fi
    echo "====================================================="
    echo "                     $tgt"
    echo "====================================================="
    check_dg.sh logs/${tgt}-${!LI} build/opt/freescale/$tgt/logs
done
banner "PERF"
for tgt in $TGTLIST; do
    TI="TDYOK${tgt}"
    LI="LASTOK${tgt}"
    BI="BUILDOK${tgt}"
    [ "${!BI}" = "" ] && continue
    if [ "${!TI}" = "${!LI}" ]; then
	continue
    fi
    echo "====================================================="
    echo "                     $tgt"
    echo "====================================================="
    if [ -f logs/${tgt}-${!LI}/${tgt}-${!LI}_best_0.target_log ]; then
	bmksum.pl -compare ${tgt}-${!LI}_best_0 \
	    logs/${tgt}-${!LI}/${tgt}-${!LI}_best_0.target_log \
	    build/opt/freescale/$tgt/logs/${tgt}-r${REV}_best_0.target_log
    fi
done

# Step 6 - Set to repeat itself tomorrow
# echo "/proj/ppc/DT/labhome/b30502/build_repo/build_gnu/build_at.sh" | at 12:01am
# Repeat at india time 12.00 AM
echo "/proj/ppc/DT/labhome/b30502/build_repo/build_gnu/build_at.sh" | at 11:30am
