#!/bin/bash

if [ $# -lt 2 ]; then
    echo "Usage is;"
    echo "    $0 [<source tree> <results tag>]..."
    exit 0
elif [ $# -eq 4 ]; then
    DOCOMP="Y"
fi

LDIR=`pwd`
TYPE=`uname -m`

while [ $# -ne 0 ]; do
    TESTS2=$TESTS
    TREE=$1
    TESTS=$2
    shift
    shift
    for bits in 32 64; do
	INSTDIR=$LDIR/install_binutils${bits}

	if [ "$TYPE" = "ppc" -o "$TYPE" = "ppc64" ]; then
	    TYPECONFIG="--build=powerpc-linux"
	else
	    TYPECONFIG="--with-sysroot=$INSTDIR/powerpc-linux/libc"
	fi
	if [ "$bits" = "64" ]; then
	    BIARCH="--enable-targets=powerpc-linux,powerpc64-linux"
	else
	    BIARCH=""
	fi

	rm -rf obj_bin${bits} $INSTDIR $LDIR/log${bits}.*
	rm -rf ${TESTS}-${bits}-binutils.log ${TESTS}-${bits}-ld.log ${TESTS}-${bits}-gas.log
	mkdir obj_bin${bits}
	cd obj_bin${bits}

	echo "Configuring $TESTS in $bits bits"
	$TREE/configure --prefix=$INSTDIR --target=powerpc-linux $TYPECONFIG $BIARCH > $LDIR/log${bits}.01-configure 2>&1
	if [ $? != 0 ]; then echo "...Error on 01"; exit 0; fi
	
	echo "Building    $TESTS in $bits bits"
	make -j 10 all > $LDIR/log${bits}.02-build 2>&1
	if [ $? != 0 ]; then echo "...Error on 02"; exit 0; fi
	
	echo "Installing  $TESTS in $bits bits"
	make -j 10 install > $LDIR/log${bits}.03-install 2>&1
	if [ $? != 0 ]; then echo "...Error on 03"; exit 0; fi
	
	echo "Testing     $TESTS in $bits bits"
	make -j 10 -k check > $LDIR/log${bits}.04-test 2>&1
	cp -f ./binutils/binutils.log ../${TESTS}-${bits}-binutils.log
	cp -f ./ld/ld.log ../${TESTS}-${bits}-ld.log
	cp -f ./gas/testsuite/gas.log ../${TESTS}-${bits}-gas.log
	cd ../
    done
done

if [ "$DOCOMP" = "Y" ]; then
    for f in 32-binutils.log 32-gas.log 32-ld.log 64-binutils.log 64-gas.log 64-ld.log; do
	echo "########## Comparing $f results"
	check_dg.sh -cmp ${TESTS2}-$f ${TESTS}-$f
    done
fi
