#!/bin/bash

function build_tool () {
    if [ ! -f $REPODIR/build_gnu_bin/check_dg.$1 ]; then
	mkdir -p $REPODIR/build_gnu_bin
	gcc -O3 -o $REPODIR/build_gnu_bin/check_dg.$1 $REPODIR/build_gnu/check_dg.c -I/usr/include/glib-2.0 -I/usr/lib64/glib-2.0/include -lglib-2.0 -lpthread
    fi
}

scriptdir=`dirname $0`
hnfull=`hostname`
hn=`basename $hnfull .am.freescale.net`
case $hn in
    lc2*-tx30) hn=lsf_host
esac
source $scriptdir/build.env-$hn

# Now I have variable REPODIR
if [ "$REPODIR" = "" ]; then
    echo "Set REPODIR first"
    exit 0
fi

m=`uname -m`
if [ "$m" = "ppc" -o "$m" = "ppc64" ]; then
    build_tool ppc
    $REPODIR/build_gnu_bin/check_dg.ppc $@
else
    build_tool x86
    $REPODIR/build_gnu_bin/check_dg.x86 $@
fi
