/*
 * Test Case for _amem8
 * This is an example test case
 * 
 * Created by:  Stephen Dew
 * Created on: Dec 2010.
 * 
 */

#ifdef   PA_TEST 
#include "portTItoPA.h"
#endif

#include <stdio.h>
#include <math.h>
#include "testdefs.h"

extern void test_print_start(char *function);
void test_print_inputs(int number, ...);
extern void test_print_output(UWORD32 val);
extern void test_print_end(char *function);

void test__amem8()
{
	UWORDLL result;
	UWORD64 vectors[8] = {
				0x0001000000020000, 0x0004000000080000,
				0x8001000080020000, 0x8004000080080000,
				0x0001000000020000, 0x0004000000080000,
				0x8001000080020000, 0x8004000080080000
				};

	#pragma align vectors 8
	UWORD64 *p_vector;	int i;

		/* Start of tests */
	test_print_start("_amem8");

	p_vector = (UWORD64 *) vectors;
	for(i=0;i<8;i++, p_vector++)
	{
		result = _amem8(p_vector);
		test_print_input_longlong(*p_vector);
		test_print_output_longlong(result);
	}
	/* End of tests */
	test_print_end("_amem8");



	return;

}
