/*
 * This source file defines functions for the display of test results 
 * and should be used in a consistent manner
 * 
 * Created by:  Michael Fleischer
 * Created:  08-29-2008
 * Version 1.0
 * 
 * Version 1.1
 * Updated by:  Yongquing Liang
 * Date: 09-04-2008
 * Changes:  Added 64 bit output printing function
 * 
 * Version 1.2
 * Updated by:  Yongquing Liang
 * Date: 09-15-2008
 * Changes:  Removed test_print_inputs_1
 *
 * Version 1.3
 * Updated by:  Yongquing Liang
 * Date: 10-01-2008
 * Changes:  Added test_print_output_double_hex
 */


#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include "testdefs.h"

char filename[255];

void set_output_filename(char *name)
{
	FILE *fout;
	
	if(name[0] != NULL)
	{
		strcpy(filename, name);
	} else
	{
		strcpy(filename, "result.txt\0");
	}
	/* Open the file handle for writing in text mode */
	if((fout = fopen(filename, "wt")) == NULL)
	{
		printf("Failed to open file %s\n", filename);
		return;
	}
	
	fclose(fout);		
}

void test_print_start(char *function)
{
	FILE *fout;
	/* Open the file handle for writing in text mode */
	if((fout = fopen(filename, "at")) == NULL)
	{
		printf("Failed to open file %s\n", filename);
		return;
	}
	
	/*Print the name of the function being tested*/
	fprintf(fout, "Test Started for function %s\n", function);
	fclose(fout);

#ifdef CONSOLE_OUTPUT
	fprintf(stdout, "Test Started for function %s\n", function);
#endif

}

void test_print_inputs(int number, ...)
{
	FILE *fout;
	va_list my_list;
	unsigned int value;
	int i;
	
	/* Open the file handle for writing in text mode */
	if((fout = fopen(filename, "at")) ==NULL)
	{
		printf("Failed to open file %s\n", filename);
		return;
	}
	
	/*Print the inputs */
	fprintf(fout, "Input(s):  ");
#ifdef CONSOLE_OUTPUT
	fprintf(stdout, "Input(s):  ");
#endif

	/* Loop through the number of inputs and print them out */
	va_start(my_list, number);	
	for(i=0;i<number;i++)
	{
		value = va_arg(my_list, UWORD32);
//		value = va_arg(my_list, unsigned long int);
		fprintf(fout, "0x%08x ", value);
#ifdef CONSOLE_OUTPUT
		fprintf(stdout, "0x%08x ", value);
#endif
	}
	va_end(my_list);
	fprintf(fout, "\n");
	#ifdef CONSOLE_OUTPUT
		fprintf(stdout, "\n");
	#endif	

	fclose(fout);

}

void test_print_output(UWORD32 value)
{
	FILE *fout;
	
	/* Open the file handle for writing in text mode */
	if((fout = fopen(filename, "at")) ==NULL)
	{
		printf("Failed to open file %s\n", filename);
		return;
	}
	
	/*Print the outputs */
	fprintf(fout, "Output:  0x%08x\n", value);
#ifdef CONSOLE_OUTPUT
	fprintf(stdout, "Output:  0x%08x\n", value);
#endif
	fclose(fout);
		
}

void test_print_end(char *function)
{
	FILE *fout;
	/* Open the file handle for writing in text mode */
	if((fout = fopen(filename, "at")) ==NULL)
	{
		printf("Failed to open file %s\n", filename);
		return;
	}
	
	/*Print the name of the function being tested*/
	fprintf(fout, "Test Ended for function %s\n", function);
	fprintf(fout, "****************************\n", function);
	fclose(fout);

#ifdef CONSOLE_OUTPUT
	fprintf(stdout, "Test Ended for function %s\n", function);
	fprintf(stdout, "****************************\n", function);
#endif

}

void test_print_output_double_hex(DOUBLE value)
{
	FILE *fout;
	
	/* Open the file handle for writing in text mode */
	if((fout = fopen(filename, "at")) ==NULL)
	{
		printf("Failed to open file %s\n", filename);
		return;
	}
	
	/*Print the outputs */
	fprintf(fout, "Output: 0x%08x", *((int *)&value));
	fprintf(fout, "%08x\n", *((int *)&value+1));
	//	fprintf(fout, "    %e\n", value);
#ifdef CONSOLE_OUTPUT
	fprintf(stdout, "Output: 0x%08x", *((int *)&value));
	fprintf(stdout, "%08x\n", *((int *)&value+1));
	//	fprintf(stdout, "    %e\n", value);
#endif
	fclose(fout);
	
}

void test_print_output_double(DOUBLE value)
{
	FILE *fout;
	
	/* Open the file handle for writing in text mode */
	if((fout = fopen(filename, "at")) ==NULL)
	{
		printf("Failed to open file %s\n", filename);
		return;
	}
	
	/*Print the outputs */
	fprintf(fout, "Output: ");
	fprintf(fout, "    %e\n", value);
#ifdef CONSOLE_OUTPUT
	fprintf(stdout, "Output: ");
	fprintf(stdout, "    %e\n", value);
#endif
	fclose(fout);
	
}

void test_print_input_double(DOUBLE value)
{
	FILE *fout;
	
	/* Open the file handle for writing in text mode */
	if((fout = fopen(filename, "at")) ==NULL)
	{
		printf("Failed to open file %s\n", filename);
		return;
	}
	

	/*Print the inputs */
	fprintf(fout, "Input: ");
	fprintf(fout, "    %e\n", value);
#ifdef CONSOLE_OUTPUT
	fprintf(stdout, "Input: ");
	fprintf(stdout, "    %e\n", value);
#endif
	fclose(fout);
	
}

void test_print_input_double_hex(DOUBLE value)
{
	FILE *fout;
	
	/* Open the file handle for writing in text mode */
	if((fout = fopen(filename, "at")) ==NULL)
	{
		printf("Failed to open file %s\n", filename);
		return;
	}
	
	/*Print the outputs */
	fprintf(fout, "Input:  0x%08x", *((int *)&value));
	fprintf(fout, "%08x\n", *((int *)&value+1));
	//	fprintf(fout, "    %e\n", value);
#ifdef CONSOLE_OUTPUT
	fprintf(stdout, "Input:  0x%08x", *((int *)&value));
	fprintf(stdout, "%08x\n", *((int *)&value+1));
	//	fprintf(stdout, "    %e\n", value);
#endif
	fclose(fout);
	
}

void test_print_output_word64(WORD64 value)
{
	FILE *fout;
	
	/* Open the file handle for writing in text mode */
	if((fout = fopen(filename, "at")) ==NULL)
	{
		printf("Failed to open file %s\n", filename);
		return;
	}
	
	/*Print the outputs */
	fprintf(fout, "Output: 0x%08x", *((int *)&value));
	fprintf(fout, "%08x\n", *((int *)&value+1));
#ifdef CONSOLE_OUTPUT
	fprintf(stdout, "Output: 0x%08x", *((int *)&value));
	fprintf(stdout, "%08x\n",*((int *)&value+1));
#endif
	fclose(fout);
}

void test_print_output_longlong(long long value)
{
	FILE *fout;
	
	/* Open the file handle for writing in text mode */
	if((fout = fopen(filename, "at")) ==NULL)
	{
		printf("Failed to open file %s\n", filename);
		return;
	}
	
	/*Print the outputs */
	fprintf(fout, "Output: 0x%08x", *((int *)&value));
	fprintf(fout, "%08x\n", *((int *)&value+1));
#ifdef CONSOLE_OUTPUT
	fprintf(stdout, "Output: 0x%08x", *((int *)&value));
	fprintf(stdout, "%08x\n",*((int *)&value+1));
#endif
	fclose(fout);	
}

void test_print_input_longlong(long long value)
{
	FILE *fout;
	
	/* Open the file handle for writing in text mode */
	if((fout = fopen(filename, "at")) ==NULL)
	{
		printf("Failed to open file %s\n", filename);
		return;
	}
	
	/*Print the outputs */
	fprintf(fout, "Input:  0x%08x", *((int *)&value));
	fprintf(fout, "%08x\n", *((int *)&value+1));
#ifdef CONSOLE_OUTPUT
	fprintf(stdout, "Input:  0x%08x", *((int *)&value));
	fprintf(stdout, "%08x\n",*((int *)&value+1));
#endif
	fclose(fout);	
}

void test_print_output_float(FLOAT value)
{
	FILE *fout;
	
	/* Open the file handle for writing in text mode */
	if((fout = fopen(filename, "at")) ==NULL)
	{
		printf("Failed to open file %s\n", filename);
		return;
	}
	
	/*Print the outputs */
	fprintf(fout, "Output: 0x%08x    %e\n", *((int *)&value), value);
#ifdef CONSOLE_OUTPUT
	fprintf(stdout, "Output: 0x%08x    %e\n", *((int *)&value), value);
#endif
	fclose(fout);
	
}

void test_print_input_float(FLOAT value)
{
	FILE *fout;
	
	/* Open the file handle for writing in text mode */
	if((fout = fopen(filename, "at")) ==NULL)
	{
		printf("Failed to open file %s\n", filename);
		return;
	}
	
	/*Print the outputs */
	fprintf(fout, "Input:  0x%08x    %e\n", *((int *)&value), value);
#ifdef CONSOLE_OUTPUT
	fprintf(stdout, "Input:  0x%08x    %e\\n", *((int *)&value), value);
#endif
	fclose(fout);
	
}

