#!/bin/bash

# Arguments are the following
MLTYPE=$1
BD=$2
HTOOLS=$3
TLIBS=$4
TOOLS=$5
PREFIX=$6
UniqueID=$7
SUB=$8
FLGS="$9"

HLOG=$BD/${UniqueID}.host_log

source $BD/f-test/set_flags.sh

cd $BD/installed_eembc/DENbench-1.0/consumer
if [ "$TGURU_C" = "" ]; then
    export TGURU_C=$HTOOLS/$TOOLS/bin/${PREFIX}gcc
fi
if [ "$TGURU_LD" = "" ]; then
    export TGURU_LD=$HTOOLS/$TOOLS/bin/${PREFIX}gcc
fi
if [ "$TGURU_AS" = "" ]; then
    export TGURU_AS=$HTOOLS/$TOOLS/bin/${PREFIX}as
fi
if [ "$TGURU_AR" = "" ]; then
    export TGURU_AR=$HTOOLS/$TOOLS/bin/${PREFIX}ar
fi
export TGURU_SIZE=$HTOOLS/$TOOLS/bin/${PREFIX}size
export TGURU_INCLUDE=$HTOOLS/$TOOLS/include
export TGURU_FLAGS_C="$FLGS $T_CFLAGS"
export TGURU_FLAGS_LD="$T_LFLAGS -lm"
export TGURU_FLAGS_DEBUG="-g"
export TGURU_PDF_PASS1="-fprofile-generate"
export TGURU_PDF_PASS2="-fprofile-use"
export TGURU_FLAGS_WARN="-pedantic -fno-asm -fsigned-char \
       -Wcomment -W -Wparentheses -Wreturn-type -Wswitch -Wunused -Wsign-compare \
       -Wimplicit -Wreturn-type -Wshadow -Wpointer-arith -Wwrite-strings \
       -Wsign-compare -Wstrict-prototypes -Wmissing-prototypes -Wmissing-declarations"

make TCDIR=../util/make VER="v2" TOOLCHAIN=gcc LITE="_lite" clean >> consumer_build.$MLTYPE.out 2>&1
rm -f *.log
rm -f gcc/bin_lite/*
make TCDIR=../util/make VER="v2" TOOLCHAIN=gcc LITE="_lite" cheader >> consumer_build.$MLTYPE.out 2>&1
make TCDIR=../util/make VER="v2" TOOLCHAIN=gcc LITE="_lite" targets >> consumer_build.$MLTYPE.out 2>&1

P=""
F=""
# Those never validates (32 and 64)
#    mp2enf32data1    mp2enf32data2    mp2enf32data3    mp2enf32data4    mp2enf32data5 
if [ "$SUB" = "all" ]; then
    blist=" \
    mp2decodf32psnr1 mp2decodf32psnr2 mp2decodf32psnr3 mp2decodf32psnr4 mp2decodf32psnr5 \
    mp2decodfixpsnr1 mp2decodfixpsnr2 mp2decodfixpsnr3 mp2decodfixpsnr4 mp2decodfixpsnr5 \
    mp2decoddata1    mp2decoddata2    mp2decoddata3    mp2decoddata4    mp2decoddata5 \
    mp2enfixdata1    mp2enfixdata2    mp2enfixdata3    mp2enfixdata4    mp2enfixdata5 \
    mp4decodedata1   mp4decodedata2   mp4decodedata3   mp4decodedata4   mp4decodedata5 \
    mp4decodepsnr1   mp4decodepsnr2   mp4decodepsnr3   mp4decodepsnr4   mp4decodepsnr5 \
    mp4encodedata1   mp4encodedata2   mp4encodedata3   mp4encodedata4   mp4encodedata5 \
    mp3playerfixeddata1 mp3playerfixeddata2 mp3playerfixeddata3 mp3playerfixeddata4 mp3playerfixeddata5 \
    cjpegv2data1     cjpegv2data2     cjpegv2data3     cjpegv2data4     cjpegv2data5   cjpegv2data6   cjpegv2data7 \
    djpegv2data1     djpegv2data2     djpegv2data3     djpegv2data4     djpegv2data5   djpegv2data6   djpegv2data7 \
    rgbcmykv2data1   rgbcmykv2data2   rgbcmykv2data3   rgbcmykv2data4   rgbcmykv2data5 rgbcmykv2data6 rgbcmykv2data7 \
    rgbhpgv2data1    rgbhpgv2data2    rgbhpgv2data3    rgbhpgv2data4    rgbhpgv2data5  rgbhpgv2data6  rgbhpgv2data7 \
    rgbyiqv2data1    rgbyiqv2data2    rgbyiqv2data3    rgbyiqv2data4    rgbyiqv2data5  rgbyiqv2data6  rgbyiqv2data7 \
    aes huffde"
else
    blist=$SUB
fi
for e in $blist; do
    if [ -e gcc/bin_lite/${e}_lite.exe ]; then
	echo "BMK=consumer-2.${e} COMP=Y" >> $HLOG
	P="$P ${e}_lite"
    else
	echo "BMK=consumer-2.${e} COMP=N" >> $HLOG
	F="$F ${e}_lite"
    fi
done
nP=0
nF=0
for n in $P; do
    let nP=$nP+1
done
for n in $F; do
    let nF=$nF+1
done
echo "..PASS $nP FAIL $nF"
