#!/bin/bash

# Arguments are the following
COREML=$1
BD=$2
TU=$3
TN=$4
UniqueID=$5
SUB=$6
SIM=$7
[ "$SIM" = "none" ] && SIM=""

TLOG=$BD/${UniqueID}.target_log
echo "CORE=$COREML" >> $TLOG

cd $BD/tmp
P=""
F=""
# Those never validates (32 and 64)
#    mp2enf32data1    mp2enf32data2    mp2enf32data3    mp2enf32data4    mp2enf32data5 
if [ "$SUB" = "all" ]; then
    blist=" \
    mp2decodf32psnr1 mp2decodf32psnr2 mp2decodf32psnr3 mp2decodf32psnr4 mp2decodf32psnr5 \
    mp2decodfixpsnr1 mp2decodfixpsnr2 mp2decodfixpsnr3 mp2decodfixpsnr4 mp2decodfixpsnr5 \
    mp2decoddata1    mp2decoddata2    mp2decoddata3    mp2decoddata4    mp2decoddata5 \
    mp2enfixdata1    mp2enfixdata2    mp2enfixdata3    mp2enfixdata4    mp2enfixdata5 \
    mp4decodedata1   mp4decodedata2   mp4decodedata3   mp4decodedata4   mp4decodedata5 \
    mp4decodepsnr1   mp4decodepsnr2   mp4decodepsnr3   mp4decodepsnr4   mp4decodepsnr5 \
    mp4encodedata1   mp4encodedata2   mp4encodedata3   mp4encodedata4   mp4encodedata5 \
    mp3playerfixeddata1 mp3playerfixeddata2 mp3playerfixeddata3 mp3playerfixeddata4 mp3playerfixeddata5 \
    cjpegv2data1     cjpegv2data2     cjpegv2data3     cjpegv2data4     cjpegv2data5   cjpegv2data6   cjpegv2data7 \
    djpegv2data1     djpegv2data2     djpegv2data3     djpegv2data4     djpegv2data5   djpegv2data6   djpegv2data7 \
    rgbcmykv2data1   rgbcmykv2data2   rgbcmykv2data3   rgbcmykv2data4   rgbcmykv2data5 rgbcmykv2data6 rgbcmykv2data7 \
    rgbhpgv2data1    rgbhpgv2data2    rgbhpgv2data3    rgbhpgv2data4    rgbhpgv2data5  rgbhpgv2data6  rgbhpgv2data7 \
    rgbyiqv2data1    rgbyiqv2data2    rgbyiqv2data3    rgbyiqv2data4    rgbyiqv2data5  rgbyiqv2data6  rgbyiqv2data7 \
    aes huffde"
else
    blist=$SUB
fi
for e in $blist; do
    sh -c "$SIM ./${e}_lite.exe > ${e}_lite.log 2> ${e}_lite.err" >> ${e}_lite.err 2>&1
    let n=$?
    x=`cat ${e}_lite.err`
    if [ $n = 0 -a "$x" = "" ]; then
	echo "BMK=consumer-2.${e} EXEC=Y" >> $TLOG
	P="$P ${e}_lite"
    else
	echo "BMK=consumer-2.${e} EXEC=N" >> $TLOG
	F="$F ${e}_lite"
    fi
done
nP=0
nF=0
for n in $P; do
    let nP=$nP+1
done
for n in $F; do
    let nF=$nF+1
done
echo "..PASS $nP FAIL $nF"
