#!/bin/bash

# Arguments are the following
CORE=$1
BD=$2
TN=$3
tag=$4
rep=$5
SUB=$6
FLGS="$7"
KEEP="$8"

if [ "$KEEP" != "" ]; then
    KEEP="-keep"
fi

mkdir -p $BD/job_server
cd $BD/job_server
rm -rf *

cp $BD/installed_eembc/DENbench-1.0/consumer/gcc/bin_lite/*.exe .

if [ "$SUB" = "all" ]; then
    blist=" \
    mp2decodf32psnr1 mp2decodf32psnr2 mp2decodf32psnr3 mp2decodf32psnr4 mp2decodf32psnr5 \
    mp2decodfixpsnr1 mp2decodfixpsnr2 mp2decodfixpsnr3 mp2decodfixpsnr4 mp2decodfixpsnr5 \
    mp2decoddata1    mp2decoddata2    mp2decoddata3    mp2decoddata4    mp2decoddata5 \
    mp2enfixdata1    mp2enfixdata2    mp2enfixdata3    mp2enfixdata4    mp2enfixdata5 \
    mp4decodedata1   mp4decodedata2   mp4decodedata3   mp4decodedata4   mp4decodedata5 \
    mp4decodepsnr1   mp4decodepsnr2   mp4decodepsnr3   mp4decodepsnr4   mp4decodepsnr5 \
    mp4encodedata1   mp4encodedata2   mp4encodedata3   mp4encodedata4   mp4encodedata5 \
    mp3playerfixeddata1 mp3playerfixeddata2 mp3playerfixeddata3 mp3playerfixeddata4 mp3playerfixeddata5 \
    cjpegv2data1     cjpegv2data2     cjpegv2data3     cjpegv2data4     cjpegv2data5   cjpegv2data6   cjpegv2data7 \
    djpegv2data1     djpegv2data2     djpegv2data3     djpegv2data4     djpegv2data5   djpegv2data6   djpegv2data7 \
    rgbcmykv2data1   rgbcmykv2data2   rgbcmykv2data3   rgbcmykv2data4   rgbcmykv2data5 rgbcmykv2data6 rgbcmykv2data7 \
    rgbhpgv2data1    rgbhpgv2data2    rgbhpgv2data3    rgbhpgv2data4    rgbhpgv2data5  rgbhpgv2data6  rgbhpgv2data7 \
    rgbyiqv2data1    rgbyiqv2data2    rgbyiqv2data3    rgbyiqv2data4    rgbyiqv2data5  rgbyiqv2data6  rgbyiqv2data7 \
    aes huffde"
else
    blist=$SUB
fi

for e in $blist; do
    cat > RUN.sh <<EOF
#!/bin/bash
sh -c "../timeout \$1 ./${e}_lite.exe > ${e}_lite.log 2> ${e}_lite.err" >> ${e}_lite.err 2>&1
let n=\$?
x=\`cat ${e}_lite.err\`
z=\`grep 'Failure' ${e}_lite.log\`
r=\`grep 'Iterations/Sec' ${e}_lite.log | awk '{print \$4}'\`
if [ \$n = 0 -a "\$x" = "" -a "\$z" = "" ]; then
    echo "VALID \$r"
else
    echo "NOTVALID 0"
fi
EOF
    chmod 755 RUN.sh

    tar cf consumer-2-${e}_lite.tar ${e}_lite.exe RUN.sh
    jsq.sh $TN tag=${tag} ${e} x=$rep e=$BD/job_server/consumer-2-${e}_lite.tar core=$CORE flgs="$FLGS" $KEEP
done
