#!/bin/bash

# Arguments are the following
CORE=$1
BD=$2
TN=$3
tag=$4
rep=$5
SUB=$6
FLGS="$7"
KEEP="$8"

if [ "$KEEP" != "" ]; then
    KEEP="-keep"
fi

mkdir -p $BD/job_server
cd $BD/job_server
rm -rf *

cp $BD/installed_eembc/coremark_v1.0/coremark.exe .

cat > RUN.sh <<EOF
#!/bin/bash
sh -c "../timeout \$1 ./coremark.exe 0x0 0x0 0x66 0 7 1 2000 > run1.log 2> run1.err" >> run1.err 2>&1
let n=\$?
x=\`cat run1.err\`
z=\`grep '^Correct operation validated' run1.log\`
r=\`grep '^Iterations/Sec' run1.log | awk '{print \$3}'\`

if [ \$n = 0 -a "\$x" = "" -a "\$z" != "" ]; then
    # Execution successful
    echo "VALID \$r"
else
    # Execution failed
    echo "NOTVALID 0"
fi
EOF
chmod 755 RUN.sh

tar cf coremark.tar coremark.exe RUN.sh
jsq.sh $TN tag=$tag coremark x=$rep e=$BD/job_server/coremark.tar core=$CORE flgs="$FLGS" $KEEP
