#!/bin/bash

# Arguments are the following
MLTYPE=$1
BD=$2
HTOOLS=$3
TLIBS=$4
TOOLS=$5
PREFIX=$6
UniqueID=$7
SUB=$8
FLGS="$9"

HLOG=$BD/${UniqueID}.host_log

source $BD/f-test/set_flags.sh

cd $BD/installed_linpack
if [ "$TGURU_C" = "" ]; then
    export TGURU_C=$HTOOLS/$TOOLS/bin/${PREFIX}gcc
fi
export TGURU_FLAGS_C="$FLGS $T_CFLAGS $T_LFLAGS"
rm -f linpack.exe
$TGURU_C $TGURU_FLAGS_C linpack.c -o linpack.exe -lm > linpack_build.$MLTYPE.out 2>&1
if [ -e linpack.exe ]; then
    # Compilation successful
    echo "BMK=linpack COMP=Y" >> $HLOG
    echo "..PASS"
else
    # Compilation failed
    echo "BMK=linpack COMP=N" >> $HLOG
    echo "..FAIL"
fi
