#!/bin/bash

# Arguments are the following
COREML=$1
BD=$2
TU=$3
TN=$4
UniqueID=$5
SUB=$6

TLOG=$BD/${UniqueID}.target_log
echo "CORE=$COREML" >> $TLOG

source $BD/f-test/linuxtst.env
if [ "$SUB" = "all" ]; then
    blist="gmp mpfr mpc ppl cloog"
else
    blist=$SUB
fi

cd $BD/tmp
let nP=0
let nF=0
for lt in $blist; do
    LT_FLG=""
    case $lt in
	gmp)
	    pkg_make gmp-5.0.5 "" test "" "$NJOBS check"
	    ;;
	mpfr)
	    pkg_make mpfr-3.1.1 "" test "" "$NJOBS check"
	    ;;
	mpc)
	    pkg_make mpc-1.0 "" test "" "$NJOBS check"
	    ;;
	ppl)
	    pkg_make ppl-0.12.1 "" test "" "$NJOBS check"
	    ;;
	cloog)
	    pkg_make cloog-0.16.3 "" test "" "$NJOBS check"
	    ;;
	eglibc)
	    cd eglibc-2.15_obj
	    sed -i -n '/cross-compiling/s@ifeq@ifneq@g' ../eglibc-2.15/localedata/Makefile
	    cp ../eglibc-2.15/iconvdata/gconv-modules iconvdata
	    cd ../
	    pkg_make eglibc-2.15 "eglibc-2.15_obj" test "" "$NJOBS -k check"
	    ;;
    esac
    if [ "$LT_FLG" = "" ]; then
	echo "BMK=linuxtst.$lt EXEC=Y" >> $TLOG
	let nP=$nP+1
    else
	echo "BMK=linuxtst.$lt EXEC=N" >> $TLOG
	let nF=$nF+1
    fi
done
echo "..PASS $nP FAIL $nF"
