#!/bin/bash

# Arguments are the following
BD=$1
TU=$2
TN=$3
UniqueID=$4
SUB=$5
KEEP=$6

TLOG=$BD/${UniqueID}.target_log

if [ "$SUB" = "all" ]; then
    blist1="applu appsp buk embar fftpde"
    blist2="cgm"
else
    if [ "$SUB" = "cgm" ]; then
	blist1=""
	blist2=$SUB
    else
	blist1=$SUB
	blist2=""
    fi
fi

cd $BD/tmp_nas
P=""
F=""
for prog in $blist1; do
    if cmp -s $prog.output $prog.out-ref ; then
	echo "BMK=nas.$prog VAL=Y" >> $TLOG
        P="$P $prog"
    else
	if [ -e $prog.out-ref2 ]; then
	    if cmp -s $prog.output $prog.out-ref2 ; then
		echo "BMK=nas.$prog VAL=Y" >> $TLOG
		P="$P $prog"
	    else
		echo "BMK=nas.$prog VAL=N" >> $TLOG
		F="$F $prog"
	    fi
	else
	    echo "BMK=nas.$prog VAL=N" >> $TLOG
            F="$F $prog"
	fi
    fi
done
for prog in $blist2; do
    cat $prog.output | grep 'reference value' > $prog.1
    cat $prog.out-ref | grep 'reference value' > $prog.2
    x=`diff $prog.1 $prog.2`
    if [ "$x" = "" ]; then
	echo "BMK=nas.$prog VAL=Y" >> $TLOG
	P="$P $prog"
    else
	echo "BMK=nas.$prog VAL=N" >> $TLOG
	F="$F $prog"
    fi
done

nP=0
nF=0
for n in $P; do
    let nP=$nP+1
done
for n in $F; do
    let nF=$nF+1
done
if [ $nF -ne 0 ]; then
    mv $BD/tmp_nas $BD/tmp_nas_SaveError
fi
echo "..PASS $nP FAIL $nF"
[ "$KEEP" != "Y" ] && rm -rf $BD/tmp_nas
