#!/bin/bash

# Arguments are the following
CORE=$1
BD=$2
TN=$3
tag=$4
rep=$5
SUB=$6
FLGS="$7"
KEEP="$8"

if [ "$KEEP" != "" ]; then
    KEEP="-keep"
fi

mkdir -p $BD/job_server
cd $BD/job_server
rm -rf *

cp $BD/installed_eembc/office-2.0/oav2/gcc/bin_lite/*.exe .

if [ "$SUB" = "all" ]; then
    blist1="bezierv2fixed bezierv2float textv2 gs8"
    blist2="ditherv2 rotatev2"
else
    if [ "$SUB" = "ditherv2" -o "$SUB" = "rotatev2" ]; then
	blist1=""
	blist2=$SUB
    else
	blist1=$SUB
	blist2=""
    fi
fi

for e in $blist1; do
    for d in 2 3 4; do
	cat > RUN.sh <<EOF
#!/bin/bash
sh -c "../timeout \$1 ./${e}_lite.exe -data${d} -do_uuencode > ${e}_d${d}_lite.log 2> ${e}_d${d}_lite.err" >> ${e}_d${d}_lite.err 2>&1
let n=\$?
x=\`cat ${e}_d${d}_lite.err\`
z=\`grep 'Failure' ${e}_d${d}_lite.log\`
r=\`grep 'Iterations/Sec' ${e}_d${d}_lite.log | awk '{print \$4}'\`
if [ \$n = 0 -a "\$x" = "" -a "\$z" = "" -a "\$r" != "" -o "${e}_d${d}" = "bezierv2float_d2" ]; then
    if [ "\$r" != "" ]; then
        echo "VALID \$r"
    else
        echo "NOTVALID 0"
    fi
else
    echo "NOTVALID 0"
fi
EOF
	chmod 755 RUN.sh

	tar cf office-2-${e}_d${d}_lite.tar ${e}_lite.exe RUN.sh
	jsq.sh $TN tag=${tag} ${e}_d${d} x=$rep e=$BD/job_server/office-2-${e}_d${d}_lite.tar core=$CORE flgs="$FLGS" $KEEP
    done
done

for e in $blist2; do
    for d in 2 3 4 5 6 7 8 9 10 11; do
	cat > RUN.sh <<EOF
#!/bin/bash
sh -c "../timeout \$1 ./${e}_lite.exe -data${d} -do_uuencode > ${e}_d${d}_lite.log 2> ${e}_d${d}_lite.err" >> ${e}_d${d}_lite.err 2>&1
let n=\$?
x=\`cat ${e}_d${d}_lite.err\`
z=\`grep 'Failure' ${e}_d${d}_lite.log\`
r=\`grep 'Iterations/Sec' ${e}_d${d}_lite.log | awk '{print \$4}'\`
if [ \$n = 0 -a "\$x" = "" -a "\$z" = "" -a "\$r" != "" ]; then
    if [ "\$r" != "" ]; then
        echo "VALID \$r"
    else
        echo "NOTVALID 0"
    fi
else
    echo "NOTVALID 0"
fi
EOF
	chmod 755 RUN.sh
	
	tar cf office-2-${e}_d${d}_lite.tar ${e}_lite.exe RUN.sh
	jsq.sh $TN tag=${tag} ${e}_d${d} x=$rep e=$BD/job_server/office-2-${e}_d${d}_lite.tar core=$CORE flgs="$FLGS" $KEEP
    done
done
