#!/bin/bash

# Arguments are the following
BD=$1
TU=$2
TN=$3
UniqueID=$4
SUB=$5
KEEP=$6

TLOG=$BD/${UniqueID}.target_log

cd $BD/tmp
P=""
F=""
if [ "$SUB" = "all" ]; then
    blist1="bezierv2fixed bezierv2float textv2 gs8"
    blist2="ditherv2 rotatev2"
else
    if [ "$SUB" = "ditherv2" -o "$SUB" = "rotatev2" ]; then
	blist1=""
	blist2=$SUB
    else
	blist1=$SUB
	blist2=""
    fi
fi
for e in $blist1; do
    for d in 2 3 4; do
	x=`grep 'Failure' ${e}_d${d}_lite.log`
	y=`grep 'Iterations/Sec' ${e}_d${d}_lite.log | awk '{print $4}'`
	if [ "$x" = "" -o "${e}_d${d}" = "bezierv2float_d2" ]; then
	    echo "BMK=office-2.${e}_d${d} VAL=Y ITER=$y" >> $TLOG
	    P="$P ${e}_d${d}_lite"
	else
	    echo "BMK=office-2.${e}_d${d} VAL=N" >> $TLOG
	    F="$F ${e}_d${d}_lite"
	fi
    done
done
for e in $blist2; do
    for d in 2 3 4 5 6 7 8 9 10 11; do
	x=`grep 'Failure' ${e}_d${d}_lite.log`
	y=`grep 'Iterations/Sec' ${e}_d${d}_lite.log | awk '{print $4}'`
	if [ "$x" = "" ]; then
	    echo "BMK=office-2.${e}_d${d} VAL=Y ITER=$y" >> $TLOG
	    P="$P ${e}_d${d}_lite"
	else
	    echo "BMK=office-2.${e}_d${d} VAL=N" >> $TLOG
	    F="$F ${e}_d${d}_lite"
	fi
    done
done

nP=0
nF=0
for n in $P; do
    let nP=$nP+1
done
for n in $F; do
    let nF=$nF+1
done
echo "..PASS $nP FAIL $nF"
[ "$KEEP" != "Y" ] && rm -rf $BD/tmp
