#!/bin/bash

# Arguments are the following
BD=$1
TU=$2
TN=$3
UniqueID=$4
SUB=$5
KEEP=$6

TLOG=$BD/${UniqueID}.target_log

if [ "$SUB" = "all" ]; then
    blist="adm arc2d dyfesm flo52 mdg mg3d qcd trfd"
else
    blist=$SUB
fi

cd $BD/tmp
P=""
F=""
for prog in $blist; do
    res="ERROR"
    [ "$prog" = "adm" ] && res="APV"
    [ "$prog" = "arc2d" ] && res="SRV"
    [ "$prog" = "dyfesm" ] && res="SDV"
    [ "$prog" = "flo52" ] && res="TFV"
    [ "$prog" = "mdg" ] && res="LWV"
    [ "$prog" = "mg3d" ] && res="SMV"
    [ "$prog" = "qcd" ] && res="LGV"
    [ "$prog" = "trfd" ] && res="TIV"
    if [ -e $res ]; then 
	x2=`grep 'RESULTS FOR THIS RUN ARE: VALID' $res`
	x1=`grep 'RESULTS FOR THIS RUN ARE:   VALID' $res`
	y=`grep 'ELAPSED CPU TIME IN SECONDS:' $res | awk '{print $6}'`
    else
	x2=""
	x1=""
    fi
    if [ "$x1" != "" -o "$x2" != "" ]; then
	echo "BMK=perfect.$prog VAL=Y TIME=$y" >> $TLOG
        P="$P $prog"
    else
	echo "BMK=perfect.$prog VAL=N" >> $TLOG
        F="$F $prog"
    fi
done

nP=0
nF=0
for n in $P; do
    let nP=$nP+1
done
for n in $F; do
    let nF=$nF+1
done
echo "..PASS $nP FAIL $nF"
[ "$KEEP" != "Y" ] && rm -rf $BD/tmp
