# Piece of script common to all *_build.sh scripts
# Imports variables: TLIBS TOOLS PREFIX MLTYPE
# Exports variables: T_CFLAGS T_LFLAGS

tgt=`echo $PREFIX | awk '{print substr($1,1,length($1)-1)}'`
Tgdir=$TLIBS/$TOOLS/$tgt
Tgsys=$Tgdir/libc
Hgdir=$HTOOLS/$TOOLS/$tgt
Hgsys=$Hgdir/libc

Ntgt=`$HTOOLS/$TOOLS/bin/gcc -v 2>&1 | grep '^Target' | awk '{print $2}'`
NTgdir=$TLIBS/$TOOLS/$Ntgt
NHgdir=$HTOOLS/$TOOLS/$Ntgt
case $MLTYPE in
    32)
	T_CFLAGS="-m32"
	T_LFLAGS="-Wl,-dynamic-linker,$Tgsys/lib/ld.so.1,-rpath,$Tgsys/lib,-rpath,$Tgsys/usr/lib,-rpath,$Tgdir/lib -L$Hgsys/lib -L$Hgdir/lib"
	;;
    64)
	T_CFLAGS="-m64 -DTGURU_LP64=1"
	T_LFLAGS="-m64 -Wl,-dynamic-linker,$Tgsys/lib64/ld64.so.1,-rpath,$Tgsys/lib64,-rpath,$Tgsys/usr/lib64,-rpath,$Tgdir/lib64 -L$Hgsys/lib64 -L$Hgdir/lib64"
	;;
    nof)
	T_CFLAGS="-msoft-float"
	T_LFLAGS="-msoft-float -Wl,-dynamic-linker,$Tgsys/nof/lib/ld.so.1,-rpath,$Tgsys/nof/lib,-rpath,$Tgsys/nof/usr/lib,-rpath,$Tgdir/lib/nof  -L$Hgsys/nof/lib -L$Hgdir/lib/nof"
	;;
    S32)
	T_CFLAGS="-m32"
	T_LFLAGS="-static -L$Hgsys/lib -L$Hgsys/usr/lib -L$Hgdir/lib"
	;;
    S64)
	T_CFLAGS="-m64 -DTGURU_LP64=1"
	T_LFLAGS="-m64 -static -L$Hgsys/lib64 -L$Hgsys/usr/lib64 -L$Hgdir/lib64"
	;;
    Snof)
	T_CFLAGS="-msoft-float"
	T_LFLAGS="-msoft-float -static -L$Hgsys/nof/lib -L$Hgsys/nof/usr/lib -L$Hgdir/lib/nof"
	;;
    N32)
	T_CFLAGS="-m32"
	T_LFLAGS="-Wl,-dynamic-linker,$NTgdir/lib/ld.so.1,-rpath,$NTgdir/lib,-rpath,$NTgdir/usr/lib -L$NHgdir/lib"
	T_ABI=32
	T_HOST=powerpc-unknown-linux-gnu
	;;
    N64)
	T_CFLAGS="-m64 -DTGURU_LP64=1"
	T_LFLAGS="-m64 -Wl,-dynamic-linker,$NTgdir/lib64/ld64.so.1,-rpath,$NTgdir/lib64,-rpath,$NTgdir/usr/lib64 -L$NHgdir/lib64"
	T_ABI=""
	T_HOST=powerpc64-unknown-linux-gnu
	;;
    Nnof)
	T_CFLAGS="-msoft-float"
	T_LFLAGS="-msoft-float -Wl,-dynamic-linker,$NTgdir/nof/lib/ld.so.1,-rpath,$NTgdir/nof/lib,-rpath,$NTgdir/nof/usr/lib,-rpath,$NTgdir/lib/nof -L$NHgdir/lib/nof"
	;;
    NS32)
	T_CFLAGS="-m32"
	T_LFLAGS="-static -L$NHgdir/lib -L$NHgdir/usr/lib"
	T_ABI=32
	T_HOST=powerpc-unknown-linux-gnu
	;;
    NS64)
	T_CFLAGS="-m64 -DTGURU_LP64=1"
	T_LFLAGS="-m64 -static -L$NHgdir/lib64 -L$NHgdir/usr/lib64"
	T_ABI=""
	T_HOST=powerpc64-unknown-linux-gnu
	;;
    NSnof)
	T_CFLAGS="-msoft-float"
	T_LFLAGS="-msoft-float -static -L$NHgdir/nof/usr/lib -L$NHgdir/lib/nof"
	;;
    X32)
	T_CFLAGS="-m32"
	T_LFLAGS="-m32"
	T_ABI=32
	T_HOST=powerpc-unknown-linux-gnu
	;;
    X64)
	T_CFLAGS="-m64 -DTGURU_LP64=1"
	T_LFLAGS="-m64"
	T_ABI=""
	T_HOST=powerpc64-unknown-linux-gnu
	;;
    XS32)
	T_CFLAGS="-m32"
	T_LFLAGS="-m32 -static"
	T_ABI=32
	T_HOST=powerpc-unknown-linux-gnu
	;;
    XS64)
	T_CFLAGS="-m64 -DTGURU_LP64=1"
	T_LFLAGS="-m64 -static"
	T_ABI=""
	T_HOST=powerpc64-unknown-linux-gnu
	;;
    vle)
	T_CFLAGS=""
	T_LFLAGS="-msim"
	;;
    vleLCF)
	T_CFLAGS=""
	T_LFLAGS="-T$BD/f-test/vleppcsim.ld -msim"
	;;
esac
