#!/bin/bash

# Arguments are the following
COREML=$1
BD=$2
TU=$3
TN=$4
UniqueID=$5
SUB=$6
SIM=$7
[ "$SIM" = "none" ] && SIM=""

TLOG=$BD/${UniqueID}.target_log
echo "CORE=$COREML" >> $TLOG

if [ "$SUB" = "all" ]; then
    blist="8q arg array bigframe BYTE_fp call1 call2 call3 call4 call5 cf copy fltconv \
	   gim incr init limits neg rel sort spill sr stdarg store struct2 struct switch wf1 yacc"
else
    blist=$SUB
fi

cd $BD/tmp
P=""
F=""
for base in $blist; do
    rm -f $base.out
    sh -c "$SIM ./$base.exe < "$base".0 > $base.out 2> $base.err" >> $base.err 2>&1
    let n=$?
    x=`cat $base.err`
    if [ $n -eq 0 -a "$x" = "" ]; then
	echo "BMK=smalltests.$base EXEC=Y" >> $TLOG
        P="$P $base"
    else
	echo "BMK=smalltests.$base EXEC=N" >> $TLOG
        F="$F $base"
    fi
done

nP=0
nF=0
for n in $P; do
    let nP=$nP+1
done
for n in $F; do
    let nF=$nF+1
done
echo "..PASS $nP FAIL $nF"
