#!/bin/bash

# Arguments are the following
MLTYPE=$1
BD=$2
HTOOLS=$3
TLIBS=$4
TOOLS=$5
PREFIX=$6
UniqueID=$7
SUB=$8
FLGS="$9"

HLOG=$BD/${UniqueID}.host_log

cd $BD/installed_spec2k6
rm -f config/default*
arch=ppc
if [ "$MLTYPE" = "32" -o "$MLTYPE" = "S32" -o "$MLTYPE" = "N32" -o "$MLTYPE" = "NS32" -o "$MLTYPE" = "X32" -o "$MLTYPE" = "XS32" ]; then
    cp -f config/testguru_${arch}_32.cfg config/default.cfg
elif [ "$MLTYPE" = "64" -o "$MLTYPE" = "S64" -o "$MLTYPE" = "N64" -o "$MLTYPE" = "NS64" -o "$MLTYPE" = "X64" -o "$MLTYPE" = "XS64" ]; then
    cp -f config/testguru_${arch}_64.cfg config/default.cfg
elif [ "$MLTYPE" = "nof" -o "$MLTYPE" = "Snof" -o "$MLTYPE" = "Nnof" -o "$MLTYPE" = "NSnof" -o "$MLTYPE" = "Xnof" -o "$MLTYPE" = "XSnof" ]; then
    cp -f config/testguru_${arch}_32.cfg config/default.cfg
fi

source $BD/f-test/set_flags.sh

source shrc
if [ "$TGURU_C" = "" ]; then
    export TGURU_C=$HTOOLS/$TOOLS/bin/${PREFIX}gcc
    export TGURU_CPP=$HTOOLS/$TOOLS/bin/${PREFIX}g++
    export TGURU_F=$HTOOLS/$TOOLS/bin/${PREFIX}gfortran
fi
export TGURU_FLAGS_C="$FLGS $T_CFLAGS"
export TGURU_FLAGS_CPP="$FLGS -fpermissive $T_CFLAGS"
export TGURU_FLAGS_F="$FLGS $T_CFLAGS"
export TGURU_FLAGS_LD="$T_LFLAGS"
export TGURU_PASS1_C=""
export TGURU_PASS1_CPP=""
export TGURU_PASS1_F=""
export TGURU_PASS1_LD=""
export TGURU_PASS2_C=""
export TGURU_PASS2_CPP=""
export TGURU_PASS2_F=""
export TGURU_PASS2_LD=""

gccver=`$TGURU_C -v 2>&1 | grep '^gcc version' | awk '{print $3}' | sed s/[.]//g`
if [ "$gccver" != "" ]; then
    if [ $gccver -ge 480 ]; then
	extension=gcc_tg48
    else
	extension=gcc_tg
    fi
else
    extension=gcc_tg
fi
if [ "$SUB" = "all" ]; then SUB=int; fi
rm -f benchspec/CPU2006/*/exe/*
runspec -a build -D -e $extension $SUB > spec2k6_build.$MLTYPE.out 2>&1
crash=$?
P=`grep '^  Building' spec2k6_build.$MLTYPE.out | awk '{printf "%s ", substr($2,5)}'`
F=`grep '^\*\*\* Error' spec2k6_build.$MLTYPE.out | awk '{printf "%s ", substr($4,5)}'`
nP=0
nF=0
for n in $P; do
    if [ "$n" != "specrand" ]; then
	echo "BMK=spec2k6.$n COMP=Y" >> $HLOG
	let nP=$nP+1
    fi
done
for n in $F; do
    if [ "$n" != "specrand" ]; then
	echo "BMK=spec2k6.$n COMP=N" >> $HLOG
	let nF=$nF+1
    fi
done
if [ $crash != 0 ]; then
    let nF=$nF+1
fi
echo "..PASS $nP FAIL $nF"
