#!/bin/bash

# Arguments are the following
BD=$1
TU=$2
TN=$3
SUB=$4

path2k6_perlbench="benchspec/CPU2006/400.perlbench/exe"
path2k6_bzip2="benchspec/CPU2006/401.bzip2/exe"
path2k6_gcc="benchspec/CPU2006/403.gcc/exe"
path2k6_mcf="benchspec/CPU2006/429.mcf/exe"
path2k6_gobmk="benchspec/CPU2006/445.gobmk/exe"
path2k6_hmmer="benchspec/CPU2006/456.hmmer/exe"
path2k6_sjeng="benchspec/CPU2006/458.sjeng/exe"
path2k6_libquantum="benchspec/CPU2006/462.libquantum/exe"
path2k6_h264ref="benchspec/CPU2006/464.h264ref/exe"
path2k6_omnetpp="benchspec/CPU2006/471.omnetpp/exe"
path2k6_astar="benchspec/CPU2006/473.astar/exe"
path2k6_xalancbmk="benchspec/CPU2006/483.xalancbmk/exe"

if [ "$SUB" = "all" ]; then
    blist="perlbench bzip2 gcc mcf gobmk hmmer sjeng libquantum h264ref omnetpp \
    astar xalancbmk"
else
    blist=$SUB
fi
for b in $blist; do
    path=path2k6_$b
    bname=$b
    if [ "$b" = "sphinx3" ]; then bname=sphinx_livepretend; fi
    if [ "$b" = "xalancbmk" ]; then bname=Xalan; fi
    exe=$BD/installed_spec2k6/${!path}/${bname}_peak.*
    if [ -e $exe ]; then
	ssh -l $TU $TN "mkdir -p $BD/exec_spec2k6/${!path} && rm -rf $BD/exec_spec2k6/${!path}/${bname}_peak.tg"
	sleep 1
	scp -q $exe $TH@$TN:$BD/exec_spec2k6/${!path}/${bname}_peak.tg
    fi
done
if [ $? = 0 ]; then
    # Copy successful
    echo "..PASS"
else
    # Copy failed
    echo "..FAIL"
fi
