#!/bin/bash

# Arguments are the following
COREML=$1
BD=$2
TU=$3
TN=$4
UniqueID=$5
SUB=$6

path2k6_perlbench="benchspec/CPU2006/400.perlbench/exe"
path2k6_bzip2="benchspec/CPU2006/401.bzip2/exe"
path2k6_gcc="benchspec/CPU2006/403.gcc/exe"
path2k6_mcf="benchspec/CPU2006/429.mcf/exe"
path2k6_gobmk="benchspec/CPU2006/445.gobmk/exe"
path2k6_hmmer="benchspec/CPU2006/456.hmmer/exe"
path2k6_sjeng="benchspec/CPU2006/458.sjeng/exe"
path2k6_libquantum="benchspec/CPU2006/462.libquantum/exe"
path2k6_h264ref="benchspec/CPU2006/464.h264ref/exe"
path2k6_omnetpp="benchspec/CPU2006/471.omnetpp/exe"
path2k6_astar="benchspec/CPU2006/473.astar/exe"
path2k6_xalancbmk="benchspec/CPU2006/483.xalancbmk/exe"

TLOG=$BD/${UniqueID}.target_log
echo "CORE=$COREML" >> $TLOG

cd $BD/exec_spec2k6
source shrc
P=""
F=""
if [ "$SUB" = "all" ]; then
    blist="perlbench bzip2 gcc mcf gobmk hmmer sjeng libquantum h264ref omnetpp \
    astar xalancbmk"
else
    blist=$SUB
fi
ML=`echo $COREML | awk -F "." '{print $2}'`
if [ "$ML" = "S32" -o "$ML" = "S64" -o "$ML" = "NS32" -o "$ML" = "NS64" ]; then
    ACTION="-a validate -i test"
else
    ACTION="-a validate"
fi
for b in $blist; do
    path=path2k6_$b
    bname=$b
    if [ "$b" = "sphinx3" ]; then bname=sphinx_livepretend; fi
    if [ "$b" = "xalancbmk" ]; then bname=Xalan; fi
    if [ -e $BD/exec_spec2k6/${!path}/${bname}_peak.tg ]; then
	sh -c "runspec -c spec_run.cfg $ACTION -e tg -n 1 $b > spec2k6_run.log 2>&1" >> spec2k6_run.log 2>&1
	v=`grep '^Success:' spec2k6_run.log`
	if [ "$v" != "" ]; then
	    l=`grep 'format: raw' spec2k6_run.log | awk '{print $4}'`
	    time=`cat $l | grep 'reported_time:' | awk '{tot=tot+$2; n=n+1} END {print tot/n}'`
	    echo "BMK=spec2k6.$b EXEC=Y TIME=$time" >> $TLOG
	    P="$P $b"
	else
	    echo "BMK=spec2k6.$b EXEC=N" >> $TLOG
	    F="$F $b"
	fi
    else
	echo "BMK=spec2k6.$b EXEC=N" >> $TLOG
	F="$F $b"
    fi
done

mkdir -p $BD/tmp_spec2k6int
echo "$P" > $BD/tmp_spec2k6int/spec2k6.pass
echo "$F" > $BD/tmp_spec2k6int/spec2k6.fail
nP=0
nF=0
for n in $P; do
    let nP=$nP+1
done
for n in $F; do
    let nF=$nF+1
done
echo "..PASS $nP FAIL $nF"
