#!/bin/bash

# Arguments are the following
COREML=$1
BD=$2
TU=$3
TN=$4
UniqueID=$5
SUB=$6

path2k_gzip="benchspec/CINT2000/164.gzip/exe"
path2k_vpr="benchspec/CINT2000/175.vpr/exe"
path2k_gcc="benchspec/CINT2000/176.gcc/exe"
path2k_mcf="benchspec/CINT2000/181.mcf/exe"
path2k_crafty="benchspec/CINT2000/186.crafty/exe"
path2k_parser="benchspec/CINT2000/197.parser/exe"
path2k_eon="benchspec/CINT2000/252.eon/exe"
path2k_perlbmk="benchspec/CINT2000/253.perlbmk/exe"
path2k_gap="benchspec/CINT2000/254.gap/exe"
path2k_vortex="benchspec/CINT2000/255.vortex/exe"
path2k_bzip2="benchspec/CINT2000/256.bzip2/exe"
path2k_twolf="benchspec/CINT2000/300.twolf/exe"
path2k_wupwise="benchspec/CFP2000/168.wupwise/exe"
path2k_swim="benchspec/CFP2000/171.swim/exe"
path2k_mgrid="benchspec/CFP2000/172.mgrid/exe"
path2k_applu="benchspec/CFP2000/173.applu/exe"
path2k_mesa="benchspec/CFP2000/177.mesa/exe"
path2k_galgel="benchspec/CFP2000/178.galgel/exe"
path2k_art="benchspec/CFP2000/179.art/exe"
path2k_equake="benchspec/CFP2000/183.equake/exe"
path2k_facerec="benchspec/CFP2000/187.facerec/exe"
path2k_ammp="benchspec/CFP2000/188.ammp/exe"
path2k_lucas="benchspec/CFP2000/189.lucas/exe"
path2k_fma3d="benchspec/CFP2000/191.fma3d/exe"
path2k_sixtrack="benchspec/CFP2000/200.sixtrack/exe"
path2k_apsi="benchspec/CFP2000/301.apsi/exe"

TLOG=$BD/${UniqueID}.target_log
echo "CORE=$COREML" >> $TLOG

cd $BD/exec_spec2k
source shrc
P=""
F=""
if [ "$SUB" = "all" ]; then
    blist="gzip vpr crafty parser eon gap vortex twolf perlbmk gcc mcf bzip2 \
    wupwise swim mgrid applu mesa galgel art equake facerec ammp lucas fma3d sixtrack apsi"
elif [ "$SUB" = "int" ]; then
    blist="gzip vpr crafty parser eon gap vortex twolf perlbmk gcc mcf bzip2"
elif [ "$SUB" = "fp" ]; then
    blist="wupwise swim mgrid applu mesa galgel art equake facerec ammp lucas fma3d sixtrack apsi"
else
    blist=$SUB
fi
ML=`echo $COREML | awk -F "." '{print $2}'`
if [ "$ML" = "S32" -o "$ML" = "S64" -o "$ML" = "NS32" -o "$ML" = "NS64" ]; then
    ACTION="-a validate -i test"
else
    ACTION="-a validate"
fi
for b in $blist; do
    path=path2k_$b
    if [ "$b" = "gcc" ]; then bname=cc1; else bname=$b; fi
    if [ -e $BD/exec_spec2k/${!path}/${bname}_peak.tg ]; then
	sh -c "runspec -c spec_run.cfg $ACTION -e tg -n 1 $b > spec2k_run.log 2>&1" >> spec2k_run.log 2>&1
	v=`grep '^Success:' spec2k_run.log`
	if [ "$v" != "" ]; then
	    l=`grep 'format: raw' spec2k_run.log | awk '{print $4}'`
	    time=`cat $l | grep 'reported_time:' | awk '{tot=tot+$2; n=n+1} END {print tot/n}'`
	    echo "BMK=spec2k.$b EXEC=Y TIME=$time" >> $TLOG
	    P="$P $b"
	else
	    echo "BMK=spec2k.$b EXEC=N" >> $TLOG
	    F="$F $b"
	fi
    else
	echo "BMK=spec2k.$b EXEC=N" >> $TLOG
	F="$F $b"
    fi
done

mkdir -p $BD/tmp_spec2k
echo "$P" > $BD/tmp_spec2k/spec2k.pass
echo "$F" > $BD/tmp_spec2k/spec2k.fail
nP=0
nF=0
for n in $P; do
    let nP=$nP+1
done
for n in $F; do
    let nF=$nF+1
done
echo "..PASS $nP FAIL $nF"
