#!/bin/bash

# Arguments are the following
CORE=$1
BD=$2
TN=$3
tag=$4
rep=$5
SUB=$6
FLGS="$7"
KEEP="$8"

if [ "$KEEP" != "" ]; then
    KEEP="-keep"
fi

path2k_gzip="benchspec/CINT2000/164.gzip/exe"
path2k_vpr="benchspec/CINT2000/175.vpr/exe"
path2k_gcc="benchspec/CINT2000/176.gcc/exe"
path2k_mcf="benchspec/CINT2000/181.mcf/exe"
path2k_crafty="benchspec/CINT2000/186.crafty/exe"
path2k_parser="benchspec/CINT2000/197.parser/exe"
path2k_eon="benchspec/CINT2000/252.eon/exe"
path2k_perlbmk="benchspec/CINT2000/253.perlbmk/exe"
path2k_gap="benchspec/CINT2000/254.gap/exe"
path2k_vortex="benchspec/CINT2000/255.vortex/exe"
path2k_bzip2="benchspec/CINT2000/256.bzip2/exe"
path2k_twolf="benchspec/CINT2000/300.twolf/exe"
path2k_wupwise="benchspec/CFP2000/168.wupwise/exe"
path2k_swim="benchspec/CFP2000/171.swim/exe"
path2k_mgrid="benchspec/CFP2000/172.mgrid/exe"
path2k_applu="benchspec/CFP2000/173.applu/exe"
path2k_mesa="benchspec/CFP2000/177.mesa/exe"
path2k_galgel="benchspec/CFP2000/178.galgel/exe"
path2k_art="benchspec/CFP2000/179.art/exe"
path2k_equake="benchspec/CFP2000/183.equake/exe"
path2k_facerec="benchspec/CFP2000/187.facerec/exe"
path2k_ammp="benchspec/CFP2000/188.ammp/exe"
path2k_lucas="benchspec/CFP2000/189.lucas/exe"
path2k_fma3d="benchspec/CFP2000/191.fma3d/exe"
path2k_sixtrack="benchspec/CFP2000/200.sixtrack/exe"
path2k_apsi="benchspec/CFP2000/301.apsi/exe"

if [ "$SUB" = "all" ]; then
    blist="gzip vpr crafty parser eon gap vortex twolf perlbmk gcc mcf bzip2 \
    wupwise swim mgrid applu mesa galgel art equake facerec ammp lucas fma3d sixtrack apsi"
elif [ "$SUB" = "int" ]; then
    blist="gzip vpr crafty parser eon gap vortex twolf perlbmk gcc mcf bzip2"
elif [ "$SUB" = "fp" ]; then
    blist="wupwise swim mgrid applu mesa galgel art equake facerec ammp lucas fma3d sixtrack apsi"
else
    blist=$SUB
fi

for b in $blist; do
    path=path2k_$b
    if [ "$b" = "gcc" ]; then bname=cc1; else bname=$b; fi
    for f in $BD/installed_spec2k/${!path}/${bname}_peak.*; do
	exe=$f
	if [ -e $exe ]; then
	    jsq.sh x=$rep 2k $b $TN tag=$tag e=$exe core=$CORE flgs="$FLGS" $KEEP
	fi
    done
done
