#!/bin/bash

# Arguments are the following
BD=$1
TU=$2
TN=$3
UniqueID=$4
SUB=$5
KEEP=$6

TLOG=$BD/${UniqueID}.target_log

cd $BD/tmp_stanford
x=`grep 'Nonfloating point composite' stanford.out | awk '{print $5*100}'`
y=`grep 'Floating point composite is' stanford.out | awk '{print $5*100}'`
if [ $"x" != "" -a $"y" != "" ]; then
    # Benchmark validated
    let iter=$x+$y
    echo "BMK=stanford VAL=Y ITER=$iter" >> $TLOG
    echo "..PASS"
else
    # Result not valid
    echo "BMK=stanford VAL=N" >> $TLOG
    echo "..FAIL"
fi
[ "$KEEP" != "Y" ] && rm -rf $BD/tmp_stanford
