#!/bin/bash

# Arguments are the following
MLTYPE=$1
BD=$2
HTOOLS=$3
TLIBS=$4
TOOLS=$5
PREFIX=$6
UniqueID=$7
SUB=$8
FLGS="$9"

HLOG=$BD/${UniqueID}.host_log

source $BD/f-test/set_flags.sh

cd $BD/installed_eembc/eembc-1.1/telecom
if [ "$TGURU_C" = "" ]; then
    export TGURU_C=$HTOOLS/$TOOLS/bin/${PREFIX}gcc
fi
if [ "$TGURU_LD" = "" ]; then
    export TGURU_LD=$HTOOLS/$TOOLS/bin/${PREFIX}gcc
fi
if [ "$TGURU_AS" = "" ]; then
    export TGURU_AS=$HTOOLS/$TOOLS/bin/${PREFIX}as
fi
if [ "$TGURU_AR" = "" ]; then
    export TGURU_AR=$HTOOLS/$TOOLS/bin/${PREFIX}ar
fi
export TGURU_SIZE=$HTOOLS/$TOOLS/bin/${PREFIX}size
export TGURU_INCLUDE=$HTOOLS/$TOOLS/include
export TGURU_FLAGS_C="$FLGS $T_CFLAGS"
export TGURU_FLAGS_LD="$T_LFLAGS -lm"
export TGURU_FLAGS_DEBUG="-g"
export TGURU_PDF_PASS1="-fprofile-generate"
export TGURU_PDF_PASS2="-fprofile-use"
export TGURU_FLAGS_WARN="-ansi -pedantic -fno-asm -fsigned-char \
       -Wcomment -W -Wparentheses -Wreturn-type -Wswitch -Wunused -Wsign-compare \
       -Wimplicit -Wreturn-type -Wshadow -Wpointer-arith -Wwrite-strings \
       -Wsign-compare -Wstrict-prototypes -Wmissing-prototypes -Wmissing-declarations"

make TCDIR=../util/make VER="" TOOLCHAIN=gcc LITE="" clean > telecom_build.$MLTYPE.out 2>&1
make TCDIR=../util/make VER="" TOOLCHAIN=gcc LITE="_lite" clean >> telecom_build.$MLTYPE.out 2>&1
rm -f *.log
rm -f gcc/bin/*
rm -f gcc/bin_lite/*
make TCDIR=../util/make VER="" TOOLCHAIN=gcc LITE="" targets >> telecom_build.$MLTYPE.out 2>&1
make TCDIR=../util/make VER="" TOOLCHAIN=gcc LITE="_lite" targets >> telecom_build.$MLTYPE.out 2>&1
P=""
F=""
if [ "$SUB" = "all" ]; then
    blist="autcor00data_1 conven00data_2 fbital00data_2 fft00data_2 viterb00data_3 \
           autcor00data_2 conven00data_3 fbital00data_3 fft00data_3 viterb00data_4 \
           autcor00data_3 fbital00data_6 viterb00data_1 conven00data_1 \
           fft00data_1 viterb00data_2"
else
    blist=$SUB
fi
for e in $blist; do
    if [ -e gcc/bin/${e}.exe ]; then
	echo "BMK=telecom-1.${e} COMP=Y" >> $HLOG
	P="$P $e"
    else
	echo "BMK=telecom-1.${e} COMP=N" >> $HLOG
	F="$F $e"
    fi
    if [ -e gcc/bin_lite/${e}_lite.exe ]; then
	echo "BMK=telecom-1.${e}_lite COMP=Y" >> $HLOG
	P="$P ${e}_lite"
    else
	echo "BMK=telecom-1.${e}_lite COMP=N" >> $HLOG
	F="$F ${e}_lite"
    fi
done
nP=0
nF=0
for n in $P; do
    let nP=$nP+1
done
for n in $F; do
    let nF=$nF+1
done
echo "..PASS $nP FAIL $nF"
