#!/bin/bash

# Arguments are the following
BD=$1
TU=$2
TN=$3
UniqueID=$4
SUB=$5
KEEP=$6

TLOG=$BD/${UniqueID}.target_log

cd $BD/tmp
P=""
F=""
if [ "$SUB" = "all" ]; then
    blist="autcor00data_1 conven00data_2 fbital00data_2 fft00data_2 viterb00data_3 \
           autcor00data_2 conven00data_3 fbital00data_3 fft00data_3 viterb00data_4 \
           autcor00data_3 fbital00data_6 viterb00data_1 conven00data_1 \
           fft00data_1 viterb00data_2"
else
    blist=$SUB
fi
for e in $blist; do
    x=`grep 'Failure' ${e}.log`
    y=`grep 'Iterations/Sec' ${e}.log | awk '{print $4}'`
    if [ "$x" = "" ]; then
	echo "BMK=telecom-1.${e} VAL=Y ITER=$y" >> $TLOG
	P="$P $e"
    else
	echo "BMK=telecom-1.${e} VAL=N" >> $TLOG
	F="$F $e"
    fi
    x=`grep 'Failure' ${e}_lite.log`
    y=`grep 'Iterations/Sec' ${e}_lite.log | awk '{print $4}'`
    if [ "$x" = ""  ]; then
	echo "BMK=telecom-1.${e}_lite VAL=Y ITER=$y" >> $TLOG
	P="$P ${e}_lite"
    else
	echo "BMK=telecom-1.${e}_lite VAL=N" >> $TLOG
	F="$F ${e}_lite"
    fi
done

nP=0
nF=0
for n in $P; do
    let nP=$nP+1
done
for n in $F; do
    let nF=$nF+1
done
echo "..PASS $nP FAIL $nF"
[ "$KEEP" != "Y" ] && rm -rf $BD/tmp
