#!/bin/bash

# Small script to expand tarballs, and build / queue performance reference runs
# Arguments are
# Directory to install tarballs. Usually "rNNN"
tdir=$1
# gcc version. Usually "4.x.x"
gccver=$2
# Job todo. Can be: "O3" to do O3 only, "opt" to do extra FSL flags only, "both" to do both
job=$3
# Tarballs for e500v2, e500mc, e55000, e6500
tarlist="$4 $5 $6 $7"

# Central place to find tarballs
if [ "$tardir" = "" ]; then
    tardir=/proj/ppc/DT/labhome/releases/build_archive
else
    echo "Retrieving tarballs from $tardir"
fi
# Central place to install tarballs
INSTDIR=/proj/ppc/DT/labhome/releases/installed

# Make sure arguments are correct
if [ "$tdir" = "" -o "$gccver" = "" -o "$tarlist" = " " ]; then
    echo "Usage is: gen_performance_runs.h <tdir> <gccver> {O3|opt|both} <tarballs>"
    exit 1
fi
if [ "$job" != "O3" -a "$job" != "opt" -a "$job" != "both" ]; then
    echo "Do not understand job: $job"
    echo "Usage is: gen_performance_runs.h <tdir> <gccver> {O3|opt|both} <tarballs>"
    exit 1
fi
for t in $tarlist; do
    if [ ! -e $tardir/$t ]; then
	echo "Cannot find tarball: $tardir/$t"
	echo "Usage is: gen_performance_runs.h <tdir> <gccver> {O3|opt|both} <tarballs>"
	exit 1
    fi
done

# base tag. Format is "DT-rNNN-4.x.x"
if [ "$btag" = "" ]; then
    btag=DT-${tdir}-${gccver}
else
    echo "Submitting jobs with tag: $btag"
fi

# Install tarballs if not already there
if [ ! -d $INSTDIR/$tdir ]; then
    mkdir -p $INSTDIR/$tdir
    cd $INSTDIR/$tdir
    for t in $tarlist; do
	echo "...Expanding $tardir/$t"
	tar xjf $tardir/$t
    done
fi

TESTLIST="coremark auto-1 consumer-1 net-1 telecom-1 office-1 consumer-2 net-2 office-2 dhrystone nbench spec2k"
FLAGLIST="-fwiden-types -mslow-mfocr -fbypass-load-on-store -fopt-array-offset"
# Submit jobs for "-O3" results
if [ "$job" != "opt" ]; then
    test.sh Htools=$INSTDIR/$tdir tools=gcc-${gccver}-XMe500v2-linuxspe/i686-linux prefix=powerpc-unknown-linux-gnuspe- hn=perf3farm17 x=5 core=e500v2 tn=perf3board1  ml=S32 tag=$btag pt="$TESTLIST" flgs="-O3"
    test.sh Htools=$INSTDIR/$tdir tools=gcc-${gccver}-XMe500mc-linux/i686-linux prefix=powerpc-unknown-linux-gnu-    hn=perf3farm17 x=5 core=e500mc tn=perf3board5  ml=S32 tag=$btag pt="$TESTLIST" flgs="-O3"
    test.sh Htools=$INSTDIR/$tdir tools=gcc-${gccver}-XMe5500-linux/i686-linux  prefix=powerpc-unknown-linux-gnu-    hn=perf3farm17 x=5 core=e5500  tn=perf3board9  ml=S32 tag=$btag pt="$TESTLIST" flgs="-O3" 
    test.sh Htools=$INSTDIR/$tdir tools=gcc-${gccver}-XMe5500-linux/i686-linux  prefix=powerpc-unknown-linux-gnu-    hn=perf3farm17 x=5 core=e5500  tn=perf3board9  ml=S64 tag=$btag pt="$TESTLIST" flgs="-O3"
    test.sh Htools=$INSTDIR/$tdir tools=gcc-${gccver}-XMe6500-linux/i686-linux  prefix=powerpc-unknown-linux-gnu-    hn=perf3farm17 x=5 core=e6500  tn=perf3board12 ml=S32 tag=$btag pt="$TESTLIST" flgs="-O3" 
    test.sh Htools=$INSTDIR/$tdir tools=gcc-${gccver}-XMe6500-linux/i686-linux  prefix=powerpc-unknown-linux-gnu-    hn=perf3farm17 x=5 core=e6500  tn=perf3board12 ml=S64 tag=$btag pt="$TESTLIST" flgs="-O3"
fi

# Submit jobs for "-O3 + FSL flags" results
if [ "$job" != "O3" ]; then
    test.sh Htools=$INSTDIR/$tdir tools=gcc-${gccver}-XMe500v2-linuxspe/i686-linux prefix=powerpc-unknown-linux-gnuspe- hn=perf3farm17 x=5 core=e500v2 tn=perf3board1  ml=S32 tag=$btag-all pt="$TESTLIST" flgs="-O3 $FLAGLIST" 
    test.sh Htools=$INSTDIR/$tdir tools=gcc-${gccver}-XMe500mc-linux/i686-linux prefix=powerpc-unknown-linux-gnu-    hn=perf3farm17 x=5 core=e500mc tn=perf3board5  ml=S32 tag=$btag-all pt="$TESTLIST" flgs="-O3 $FLAGLIST" 
    test.sh Htools=$INSTDIR/$tdir tools=gcc-${gccver}-XMe5500-linux/i686-linux  prefix=powerpc-unknown-linux-gnu-    hn=perf3farm17 x=5 core=e5500  tn=perf3board9  ml=S32 tag=$btag-all pt="$TESTLIST" flgs="-O3 $FLAGLIST" 
    test.sh Htools=$INSTDIR/$tdir tools=gcc-${gccver}-XMe5500-linux/i686-linux  prefix=powerpc-unknown-linux-gnu-    hn=perf3farm17 x=5 core=e5500  tn=perf3board9  ml=S64 tag=$btag-all pt="$TESTLIST" flgs="-O3 $FLAGLIST"
    test.sh Htools=$INSTDIR/$tdir tools=gcc-${gccver}-XMe6500-linux/i686-linux  prefix=powerpc-unknown-linux-gnu-    hn=perf3farm17 x=5 core=e6500  tn=perf3board12 ml=S32 tag=$btag-all pt="$TESTLIST" flgs="-O3 $FLAGLIST" 
    test.sh Htools=$INSTDIR/$tdir tools=gcc-${gccver}-XMe6500-linux/i686-linux  prefix=powerpc-unknown-linux-gnu-    hn=perf3farm17 x=5 core=e6500  tn=perf3board12 ml=S64 tag=$btag-all pt="$TESTLIST" flgs="-O3 $FLAGLIST"
fi
