#!/bin/bash

SERVERDIR=/proj/ppc/DT/labhome/job_server
CORES=([0]="e500v2.S32"   [1]="e500mc.S32"  [2]="e5500.S32"   [3]="e5500.S64"   [4]="e6500.S32"    [5]="e6500.S64")
BOARDS=([0]="perf3board1" [1]="perf3board5" [2]="perf3board9" [3]="perf3board9" [4]="perf3board12" [5]="perf3board12")

TAGS="F462v-r582 DT-r513 DT-r513-all DT-r721-4.6.3-all DT-r721-4.7.1-all DT-r777-4.6.3-all DT-r777-4.7.2-all \
      DT-r817-4.7.2-all DT-r877-4.7.3-all DT-r914-4.7.3-all DT-r914-4.8.1-all DT-r963-4.8.2-all DT-r990-4.8.2-all \
      DT-r1093-4.8.2-all DT-r1182-4.8.3-all DT-r1182-4.9.2-all DT-r1237-4.9.2-all"

echo "Tag: CS-2011-03-38"
echo "   core: e500mc.S32"
if [ ! -f CS-2011-03-38.e500mc.S32 ]; then
    grep e500mc.S32 $SERVERDIR/perf3board5/results | grep -v spec2k6 | convert_js.sh CS-2011-03-38 > CS-2011-03-38.e500mc.S32
fi
echo "   core: e5500.S32"
if [ ! -f CS-2011-03-38.e5500.S32 ]; then
    grep e5500.S32  $SERVERDIR/perf3board9/results | grep -v spec2k6 | convert_js.sh CS-2011-03-38 > CS-2011-03-38.e5500.S32
fi
echo "   core: e5500.S64"
if [ ! -f CS-2011-03-38.e5500.S64 ]; then
    grep e5500.S64  $SERVERDIR/perf3board9/results | grep -v spec2k6 | convert_js.sh CS-2011-03-38 > CS-2011-03-38.e5500.S64
fi
for t in $TAGS; do
    echo "Tag: $t"
    for ((i=0; i < ${#CORES[@]}; i++)); do
	core=${CORES[$i]}
	board=${BOARDS[$i]}
	echo "   core: $core"
	if [ ! -f $t.$core ]; then
	    grep $core $SERVERDIR/$board/results | grep -v spec2k6 | convert_js.sh $t > $t.$core
	fi
    done
done
