#! /bin/bash

# Arguments are:
# Gcc version ex: 4.7.2
ver=$1
# Release number ex: 801
rel=$2

if [ "$ver" = "" -o "$rel" = "" ]; then
    echo "Usage $0 <ver> <rel>"
    echo "    ex: $0 4.7.2 801"
    exit 1
fi

REL_AR_DIR=/proj/ppc/DT/labhome/edmar/build_repo/releases

LINUXFILES=(
"CDE.gcc-VVV-Ee300c2-eabi-i686-linux-rNNN.tar.bz2"
"CDE.gcc-VVV-Ee300c3-eabi-i686-linux-rNNN.tar.bz2"
"CDE.gcc-VVV-Ee500mc-eabi-i686-linux-rNNN.tar.bz2"
"CDE.gcc-VVV-Ee500v1-eabispe-i686-linux-rNNN.tar.bz2"
"CDE.gcc-VVV-Ee500v2-eabispe-i686-linux-rNNN.tar.bz2"
"CDE.gcc-VVV-Ee5500-aeabi-i686-linux-rNNN.tar.bz2"
"CDE.gcc-VVV-Ee600-eabialtivec-i686-linux-rNNN.tar.bz2"
"CDE.gcc-VVV-Ee6500-aeabi-i686-linux-rNNN.tar.bz2"
"CDE.gcc-VVV-Xe300c2-linux-i686-linux-rNNN.tar.bz2"
"CDE.gcc-VVV-XMe300c3-linux-i686-linux-rNNN.tar.bz2"
"CDE.gcc-VVV-XMe500mc-linux-i686-linux-rNNN.tar.bz2"
"CDE.gcc-VVV-XMe500v1-linuxspe-i686-linux-rNNN.tar.bz2"
"CDE.gcc-VVV-XMe500v2-linuxspe-i686-linux-rNNN.tar.bz2"
"CDE.gcc-VVV-XMe5500-linux-i686-linux-rNNN.tar.bz2"
"CDE.gcc-VVV-XMe600-linuxaltivec-i686-linux-rNNN.tar.bz2"
"CDE.gcc-VVV-XMe6500-linux-i686-linux-rNNN.tar.bz2"
);

WINFILES=(
"gcc-VVV-Ee300c2-eabi-i686-mingw32-rNNN.tar.bz2"
"gcc-VVV-Ee300c3-eabi-i686-mingw32-rNNN.tar.bz2"
"gcc-VVV-Ee500mc-eabi-i686-mingw32-rNNN.tar.bz2"
"gcc-VVV-Ee500v1-eabispe-i686-mingw32-rNNN.tar.bz2"
"gcc-VVV-Ee500v2-eabispe-i686-mingw32-rNNN.tar.bz2"
"gcc-VVV-Ee5500-aeabi-i686-mingw32-rNNN.tar.bz2"
"gcc-VVV-Ee600-eabialtivec-i686-mingw32-rNNN.tar.bz2"
"gcc-VVV-Ee6500-aeabi-i686-mingw32-rNNN.tar.bz2"
"gcc-VVV-Xe300c2-linux-i686-mingw32-rNNN.tar.bz2"
"gcc-VVV-XMe300c3-linux-i686-mingw32-rNNN.tar.bz2"
"gcc-VVV-XMe500mc-linux-i686-mingw32-rNNN.tar.bz2"
"gcc-VVV-XMe500v1-linuxspe-i686-mingw32-rNNN.tar.bz2"
"gcc-VVV-XMe500v2-linuxspe-i686-mingw32-rNNN.tar.bz2"
"gcc-VVV-XMe5500-linux-i686-mingw32-rNNN.tar.bz2"
"gcc-VVV-XMe600-linuxaltivec-i686-mingw32-rNNN.tar.bz2"
"gcc-VVV-XMe6500-linux-i686-mingw32-rNNN.tar.bz2"
);



echo "machine zro04file01.ea.freescale.net login mwbuildguru password build123" > ~/.netrc
chmod 600 ~/.netrc

CWD=`pwd`
rm -rf x
mkdir x

cd x
echo "binary" > $CWD/cmdslinux
echo "cd Components/Compiler/PACross/Linux" >> $CWD/cmdslinux
echo "Linux upload"
for p in ${LINUXFILES[@]}; do
    i=`echo $p | sed s/NNN/$rel/ - | sed s/VVV/$ver/ -`
    echo -n "    $i   "
    cp -f ${REL_AR_DIR}/$i .
    tar xjf $i
    x=`./gcc-${ver}*/i686-linux/bin/powerpc*gcc -print-libgcc-file-name`
    GCCDIR=`dirname $x`
    if [ -e $GCCDIR/specs ]; then
	rm -f $GCCDIR/specs
	echo "... specs removed"
	tar cjf $i gcc-${ver}*
    else
	echo "... No specs file"
    fi
    rm -rf gcc-${ver}*
    echo "put $i" >> $CWD/cmdslinux
done
echo "FTP execution: Putting linux files..."
#cat $CWD/cmdslinux
ftp -v zro04file01.ea.freescale.net < $CWD/cmdslinux
cd ../

pushd ${REL_AR_DIR}
echo "binary" > $CWD/cmdswin
echo "cd Components/Compiler/PACross/Windows" >> $CWD/cmdswin
echo "Windows upload"
for p in ${WINFILES[@]}; do
    i=`echo $p | sed s/NNN/$rel/ - | sed s/VVV/$ver/ -`
    echo "    $i"
    echo  "put $i" >> $CWD/cmdswin
done
echo "FTP execution: Putting Windows files..."
#cat $CWD/cmdswin
ftp -v zro04file01.ea.freescale.net < $CWD/cmdswin
popd

rm -rf ~/.netrc $CWD/cmdslinux $CWD/cmdswin x
