#!/bin/bash

# This script provide local customization of this script
scriptdir=`dirname $0`
hnfull=`hostname`
hn=`basename $hnfull .am.freescale.net`
hn=`basename $hn .mtwk.freescale.net`
source $scriptdir/build.env-$hn

# Now I have variable REPODIR
if [ "$REPODIR" = "" ]; then
    echo "Set REPODIR first"
    exit 0
fi

for p in $@; do
    echo "Installing patch $p"
    if [ -e $REPODIR/build_gnu/patches/$p ]; then
	# We want to copy everything from the beginning of file until the start of the patch
	# Patches can start with ^diff or ^--- or ^Index:
	echo "   Extracting comments"
	awk '{ if ($1=="diff" || $1=="---" || $1=="Index:") exit; else print $0}' < $REPODIR/build_gnu/patches/$p > $REPODIR/build_gnu/patches/comments
	echo "   Appending new patch to comments"
	cat $p >> $REPODIR/build_gnu/patches/comments
	chmod 666 $REPODIR/build_gnu/patches/$p
	echo "   Installing new patch"
	mv -f $REPODIR/build_gnu/patches/comments $REPODIR/build_gnu/patches/$p
	chmod 444 $REPODIR/build_gnu/patches/$p
    else
	echo "   First time install"
	cp $p $REPODIR/build_gnu/patches/$p
	chmod 444 $REPODIR/build_gnu/patches/$p
    fi
done
