#!/bin/bash

JSDIR=/proj/ppc/DT/labhome/job_server

MACH=$1

function end_server () {
    echo -e "\rTerminating server:    $MACH"
    ssh -l testguru $MACH /home/testguru/bin/board.sh unlock >/dev/null 2>&1
    exit 0
}

# Check arguments
if [ "$MACH" = "" ]; then
    echo "No job server machine was specified"
    exit 1
fi
if [ ! -e $JSDIR/$MACH/queue ]; then
    echo "This machine is not ready for job server work"
    exit 1
fi

# Starting to process queue for $MACH
echo "Locking board:         $MACH"
ssh -l testguru $MACH /home/testguru/bin/board.sh lock >/dev/null 2>&1

# Prepare to catch an exit
trap end_server SIGABRT SIGINT

# Main loop
progress=("-" "\\" "|" "/")
n_progress=0
while true; do
    # Check if there is a job to be executed
    f=`ls -1rt $JSDIR/$MACH/queue | head -n 1`
    fdir=queue
    if [ "$f" = "" ]; then
	f=`ls -1rt $JSDIR/$MACH/queuep | head -n 1`
	fdir=queuep
    fi
    if [ "$f" != "" ]; then echo -n -e "\r"; fi
    while [ "$f" != "" ]; do
	source $JSDIR/$MACH/$fdir/$f
	if [ "$KEEP" = "Y" ]; then K="-k"; else K=""; fi
	echo "Picking $f"
	if [ "$CMD" = "tar" ]; then
	    echo "    tar_run.sh -q $K tn=$MACH tu=testguru t=$TMO x=$REP e=$JSEXE"
	    tar_run.sh -q $K tn=$MACH tu=testguru t=$TMO x=$REP e=$JSEXE > job_server.$f
	else
	    echo "    spec_run.sh -q $K tn=$MACH tu=testguru t=$TMO x=$REP e=$JSEXE $CMD $BMK"
	    spec_run.sh -q $K tn=$MACH tu=testguru t=$TMO x=$REP e=$JSEXE $CMD $SUBBMK > job_server.$f
	fi
	# Remove job
	rm -f $JSDIR/$MACH/$fdir/$f
	rm -f $JSEXE
	# Record results in database
	echo "    Recording results"
        results=( $(cat job_server.$f) )
	[ "$KEEP" = "N" ] && rm -rf job_server.$f
	let j=0
	for (( i = 0 ; i < ${#results[*]} ; i+=2 )); do
	    VAL=${results[$i]}
	    RES=${results[$i+1]}
	    if [ "$VAL" != "NOTVALID" -a "$RES" != "" ]; then
		VAL="Valid"
	    else
		VAL="NOTVALID"
		RES=0
	    fi
	    let j=j+1
	    echo "TAG,$TAG,JID,$f,USR,$USR,REP,$REP,TMO,$TMO,CORE,$CORE,BMK,$BMK,SUBBMK,$SUBBMK,CMD,$CMD,EXE,$EXE,I,$j,VAL,$VAL,RES,$RES,FLGS,$FLGS" >> $JSDIR/$MACH/results
	done
	# Check queue again
	f=`ls -1rt $JSDIR/$MACH/queue | head -n 1`
	fdir=queue
	if [ "$f" = "" ]; then
	    f=`ls -1rt $JSDIR/$MACH/queuep | head -n 1`
	    fdir=queuep
	fi
    done

    # Show that job server is alive
    echo -n -e "\r" ${progress[$n_progress]}
    let n_progress=($n_progress+1)%4
    sleep 10
done