#!/bin/bash

#
# Script to run contents of a tarball remotely
#

function copy_and_run () {
    if [ "$target" = "" ]; then
	echo "Target board is not set. use t=<target> command"
	exit 1
    fi
    if [ $rep -le 0 -o $rep -gt 20 ]; then
	echo "Repetion must be number from 1 to 20: $rep"
	exit 1
    fi

    if [ "$Q" != "Y" ]; then echo "Copying $exe"; fi
    x=`basename $exe .tar`
    ssh -l $user $target mkdir -p $tardir/$x >/dev/null 2>&1
    sleep 1
    scp -q $exe $user@$target:$tardir/$x/$x.tar
    exe=""

    if [ "$Q" != "Y" ]; then echo "Executing"; fi
    for ((i=0; i<$rep; i++)); do
	ssh -l $user $target "cd $tardir/$x && tar xfm $x.tar && source ./RUN.sh $TMO" > tar_result 2>&1
	tail -n +5 tar_result
    done
    if [ "$KEEP" = "" ]; then
	rm -f tar_result
	if [ "$Q" != "Y" ]; then echo "removing $exe"; fi
	ssh -l $user $target rm -rf $tardir/$x >/dev/null 2>&1
    fi
}

# Some commands have default values
user=`id -nu`
tardir=/local/job_server
rep=3
KEEP=""
TMO=1000

for cmd in "$@"; do
    case $cmd in
        -h)
	    cat <<EOF
Usage is spec_run.sh <cmd>...

Where <cmd> is one of:
    -h            print this help and exit
    -q            quiet. Print results only
    -k            Keep intermediate results
    tn=<target>   Name of the machine to ssh to
    tu=<username> Username to ssh as. Default is user running this script
    t=<seconds>   Timeout in seconds
    s=<path>      Path of spec tree in target machine. Default is /local/spec_run
    e=<path>      Executable to run. Default is to get from benchmark exe directory
    x=9           Number of repetitions
EOF
	    exit 0
	    ;;
	-q)
	    Q="Y"
	    ;;
        -k)
	    KEEP="Y"
	    ;;
	tn=*)
            target=${cmd:3}
	    ;;
	tu=*)
            user=${cmd:3}
	    ;;
	s=*)
            tardir=${cmd:2}
	    ;;
	t=*)
            TMO=${cmd:2}
	    ;;
	e=*)
            exe=${cmd:2}
	    copy_and_run
	    ;;
	x=*)
	    let rep=${cmd:2}
	    ;;
	*)
            echo "Unkown command: $cmd"
	    ;;
    esac
done