#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <stdlib.h>

typedef int pid_t;
pid_t pid;
int debug;

void kill_it()
{
  kill(pid, SIGKILL);
}

int main(int argc, char **argv)
{
  int delay;
  int status;

  debug = 0;
  delay = atoi (argv[1]);
  if (debug)
    printf ("tmo: %d, program: %s\n", delay, argv[2]);
  if ((pid=fork ()) == 0) {
    /* child fork:  execute and terminate */
    execvp (argv[2], argv + 2);
    if (debug)
      printf ("pid: %d\n", pid);
  }
  signal (SIGALRM, kill_it);
  alarm (delay);
  wait (&status);
  exit (0);
}
