#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "releasemain.h"

/*
 * Auxiliary functions
 * ===================
 */

char *
cat3 (const char *s1, const char *s2, const char *s3)
{
  char *s;

  s = (char *) malloc (strlen (s1) + strlen (s2) + strlen (s3) + 1);
  strcpy (s, s1);
  strcat (s, s2);
  strcat (s, s3);
  return s;
}

char *
join2 (const char *s1, const char *s2)
{
  char *s;

  s = (char *) malloc (strlen (s1) + strlen (s2) + 2);
  strcpy (s, s1);
  strcat (s, " ");
  strcat (s, s2);
  return s;
}

char *
join3 (const char *s1, const char *s2, const char *s3)
{
  char *s;

  s = (char *) malloc (strlen (s1) + strlen (s2) + strlen (s3) + 3);
  strcpy (s, s1);
  strcat (s, " ");
  strcat (s, s2);
  strcat (s, " ");
  strcat (s, s3);
  return s;
}

char *
join4 (const char *s1, const char *s2, const char *s3, const char *s4)
{
  char *s;

  s = (char *) malloc (strlen (s1) + strlen (s2) + strlen (s3) + strlen (s4) + 4);
  strcpy (s, s1);
  strcat (s, " ");
  strcat (s, s2);
  strcat (s, " ");
  strcat (s, s3);
  strcat (s, " ");
  strcat (s, s4);
  return s;
}

char *
safe_strdup (char *s)
{
  if (s == NULL)
    return NULL;
  return strdup (s);
}

int
get_host_cpus (char *user, char *hname)
{
  char buf[1024];
  FILE *fres;
  char *b;

  sprintf (buf, "ssh -l %s %s 'cat /proc/cpuinfo | grep '^processor' | wc -l'", user, hname);
  fres = popen (buf, "r");
  if (fres == NULL) {
    fprintf (flog, "[get_host_cpus]    Returned NULL\n%s\n", buf);
    pclose (fres);
    return -1;
  }
  b = fgets (buf, 1024, fres);
  pclose (fres);
  if (b == NULL) {
    fprintf (stderr, "[get_host_cpus]    Unexpected error reading buffer\n");
    return -1;
  }
  return atoi (buf);
}

double
get_host_load (char *user, char *hname)
{
  char buf[1024];
  FILE *fres;
  char *b;

  sprintf (buf, "ssh -l %s %s uptime | awk '{for (i=1; i<14; i++) if ($i == \"average:\") print substr($(i+1),1,length($(i+1))-1)}'", user, hname);
  fres = popen (buf, "r");
  if (fres == NULL) {
    fprintf (flog, "[get_host_load]    Returned NULL\n%s\n", buf);
    pclose (fres);
    return -1.0;
  }
  b = fgets (buf, 1024, fres);
  pclose (fres);
  if (b == NULL) {
    fprintf (stderr, "[get_host_load]    Unexpected error reading buffer\n");
    return -1.0;
  }
  return atof (buf);
}

char *
exec_shell (char *s)
{
  FILE *fres;
  char buf[2048];
  char *p;
  int len;

  fprintf (flog, "[exec_shell]            Starting script:\n%s\n", s);
  fres = popen (s, "r");
  if (fres == NULL) {
    fprintf (stderr, "[exec_shell] popen returned NULL\n%s\n", s);
    return NULL;
  }
  buf[0] = '\0';
  p = fgets (buf, 2048, fres);
  len = strlen (buf);
  if (len != 0 && buf[len - 1] == '\n')
    buf[len - 1] = '\0';
  pclose (fres);
  if (p) fprintf (flog, "[exec_shell]            Result of script:\n%s\n", p);
  return safe_strdup (p);
}


/*
 * Double linked list functions
 * ============================
 */
// Pick one
// Create new node
// Remove this node
// Add this node

LL *
LL_pick_one (LL **root)
{
  LL *node;

  if (*root == NULL)
    return NULL;
  node = *root;

  *root = (*root)->next;
  if (*root)
    (*root)->prev = NULL;

  return node;
}

LL *
LL_create_node (Task *t)
{
  LL *l;

  l = (LL *) malloc (sizeof (LL));
  l->task = t;
  l->next = NULL;
  l->prev = NULL;
  return l;
}

void
dump_lists (void)
{
  LL *l;

  fprintf (flog, "DUMP L_ready    ");
  for (l = L_ready; l != NULL; l = l->next)
    fprintf (flog, "%4d", l->task->task_num);
  fprintf (flog, "\n");
  fprintf (flog, "DUMP L_requires ");
  for (l = L_requires; l != NULL; l = l->next)
    fprintf (flog, "%4d", l->task->task_num);
  fprintf (flog, "\n");
  fprintf (flog, "DUMP L_running  ");
  for (l = L_running; l != NULL; l = l->next)
    fprintf (flog, "%4d", l->task->task_num);
  fprintf (flog, "\n");
}

void
LL_remove_node (LL **root, LL *node)
{
  LL *l;

  if (*root == node) {
    *root = (*root)->next;
    if (*root)
      (*root)->prev = NULL;
    node->next = NULL;
    node->prev = NULL;
    dump_lists ();
    return;
  }

  for (l = *root; l != NULL; l = l->next) {
    if (l == node) {
      l->prev->next = l->next;
      if (l->next)
	l->next->prev = l->prev;
      node->next = NULL;
      node->prev = NULL;
      dump_lists ();
      return;
    }
  }
}

void
LL_add_node (LL **root, LL *node)
{
  LL *l;

  if (*root == NULL) {
    *root = node;
    node->next = NULL;
    node->prev = NULL;
    dump_lists ();
    return;
  }

  for (l = *root; l->next != NULL; l = l->next)
    ;
  l->next = node;
  node->next = NULL;
  node->prev = l;
  dump_lists ();
}

#define NUM_LOCKS 32
int locked_tmo[NUM_LOCKS];
char *locked_sets[NUM_LOCKS];

void
lock_set (char *x)
{
  int i;

  for (i = 0; i < NUM_LOCKS; i++) {
    if (locked_sets[i] == NULL) {
      locked_sets[i] = x;
      locked_tmo[i] = 120; // 2 minutes
      return;
    }
  }
}

int
is_set_locked (char *x)
{
  int i;

  for (i = 0; i < NUM_LOCKS; i++) {
    if (locked_sets[i] && strcmp (locked_sets[i], x) == 0) {
      return 1;
    }
  }
  return 0;
}

void
test_locked_tmo (void)
{
  int i;

  for (i = 0; i < NUM_LOCKS; i++) {
    if (locked_tmo[i] != 0) {
      locked_tmo[i]--;
      if (locked_tmo[i] == 0) {
	locked_sets[i] = NULL;
      }
    }
  }
}
