#ifndef RELEASECB_H
#define RELEASECB_H

#include <stdio.h>

enum {
  S_cmd, S_set, S_map, S_build, S_test,
  S_set_begin, S_set_list, S_map_begin, S_map_list,
  S_build_list, S_test_list
};

enum {
  E_ready, E_stopped, E_requires, E_blocked, E_running, E_error, E_fail, E_done
};

enum {
  T_build, T_test
};

typedef struct {
  char *id;
  int len;
  char *list[64];
} Set;

typedef struct {
  char *id;
  int len;
  char *key[64];
  char *map[64];
} Map;

typedef struct bld {
  int type;
  char *job;
  char *ml;
  char *user;
  int priority;
  char *bmk;
  char *wdir;
  char *log;
  int n_reqs;
  char *requires[8];
  struct bld *up[8];
  char *provides;
  int n_execs;
  char *execs[8];
  char *result;
  char *tarball;
  char *Wtarball;
  char *machine;
  char *target;

  // Those fields are for execution
  int status;
  char *mach;
  char *tarname;
  char *Wtarname;
  char *tools;
  int num_dependencies;

  // Those fields are for GUI
  int task_num;
} Task;

typedef struct dbl_ll {
  Task *task;
  struct dbl_ll *next;
  struct dbl_ll *prev;
} LL;


extern FILE *flog;
extern LL *L_ready;
extern LL *L_requires;
extern LL *L_running;


char *cat3 (const char *, const char *, const char *);
char *join2 (const char *, const char *);
char *join3 (const char *, const char *, const char *);
char *join4 (const char *, const char *, const char *, const char *);
char *safe_strdup (char *);
int get_host_cpus (char *, char *);
double get_host_load (char *, char *);
char *exec_shell (char *);

LL *LL_pick_one (LL **);
LL *LL_create_node (Task *);
void LL_remove_node (LL **, LL *);
void LL_add_node (LL **, LL *);
void lock_set (char *x);
int is_set_locked (char *x);
void test_locked_tmo (void);


#endif /* RELEASECB_H */
