#!/bin/bash

CDEmachine=log5-atx
if [ "$1" = "" ]; then
    CDEuser=$USER
else
    CDEuser=$1
fi
DTuser=$USER
REPODIR=/proj/ppc/DT/labhome/$USER/build_repo

for h in perf3farm17 perf3farm18 perf3farm19; do
    if [ -f $HOME/.rc/$h ]; then
	echo "Resetting $h"
	ssh -l $DTuser $h rm -rf /local/$DTuser/release /local/$DTuser/release_ML? &
    fi
done

#for h in lt03-tx30 lt04-tx30 lds14-tx30 lds15-tx30 lt02-tx30 lt07-tx30 lt08-tx30 lt10-tx30 lt11-tx30; do
#    echo "Resetting $h"
#    ssh -l $CDEuser $h rm -rf /tmp/$CDEuser/release &
#done

if [ -f $HOME/.rc/CDE ]; then
    echo "Resetting CDE jobs"
    ssh -l $CDEuser $CDEmachine.am.freescale.net bkill -u $CDEuser 0 &
fi

for h in perf3farm2 perf3farm10; do
    if [ -f $HOME/.rc/$h ]; then
	echo "Resetting $h"
	ssh -l $DTuser $h rm -rf /opt/freescale/NL*  /opt/freescale/gcc* &
    fi
done

for h in perf3farm17 perf3farm18 perf3farm19 perf3farm9 perf3farm10 perf3board1 perf3board4 perf3board7 perf3board8 perf3board12; do
    if [ -f $HOME/.rc/$h ]; then
	echo "Removing tests $h"
	ssh -l $DTuser $h rm -rf /local/$DTuser/tools_test/gcc* /local/$DTuser/tools_test/tmp /local/$DTuser/tools_test/*target_log /local/$DTuser/tools_test?/gcc* /local/$DTuser/tools_test?/tmp /local/$DTuser/tools_test?/*target_log /local/$DTuser/tools_test/*host_log /local/$DTuser/tools_test?/*host_log &
    fi
done

for h in perf3farm17 perf3farm18 perf3farm19; do
    if [ -f $HOME/.rc/$h ]; then
	echo "Killing programs on $h"
	ssh -l $DTuser $h "ps -Afl | grep expect     | awk '{x=\$4; system(\"kill -9 \" x)}'"
	ssh -l $DTuser $h "ps -Afl | grep ssh_filter | awk '{x=\$4; system(\"kill -9 \" x)}'"
	ssh -l $DTuser $h "ps -Afl | grep sim-ame    | awk '{x=\$4; system(\"kill -9 \" x)}'"
    fi
done

wait

echo "Resetting logs"
rm -rf $REPODIR/logs/*
echo "Resetting tarballs"
rm -f $REPODIR/releases/*


