#!/bin/bash

Htools=$1
tools=$2
shift
shift
if [ "$Htools" = "" -o "$tools" = "" ]; then
    echo "# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #"
    echo "WARNING: Run thins script from perf3farm17/18. It uses /local/edmar/tools_fmining directory"
    echo "WARNING: Target board is perf3board1/7/8/12. BOARD IS NOT LOCKED"
    echo "Arguments are:"
    echo "    <Htools> ex: /proj/ppc/DT/labhome/releases/installed/r721"
    echo "    <tools>  ex: gcc-4.7.1-XMe5500-linux/i686-linux"
    echo "    { e500mc e5500-32 e5500-64 }"
    echo "    { coremark | dhrystone | IPMark | TCPMark }*"
    echo "# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #"
    exit 0
fi

flgs="-O3"
core=e500mc
for a in "$@"; do
    case $a in
	flgs=*)
	    flgs=${a:5}
	    continue
	    ;;
	e500v2)
	    core=e500v2
	    continue
	    ;;
	e500mc)
	    core=e500mc
	    continue
	    ;;
	e5500*)
	    core=$a
	    continue
	    ;;
	e6500*)
	    core=$a
	    continue
	    ;;
    esac
    echo "# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #"
    echo "WARNING: Run thins script from perf3farm17/18. It uses /local/edmar/tools_fmining directory"
    echo "WARNING: Target board is perf3board7/8. BOARD IS NOT LOCKED"
    echo "# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #"
    case $a in
	coremark)
	    [ "$core" = "e500mc" ] && fmining s=strategy_gcc tag=gcc46,dt46 Htools=$Htools tools=$tools prefix=powerpc-unknown-linux-gnu- flgs="$flgs" ml=S32 tn=perf3board7 fm=coremark th=0
	    [ "$core" = "e5500-32" ] && fmining s=strategy_gcc tag=gcc46,dt46 Htools=$Htools tools=$tools prefix=powerpc-unknown-linux-gnu- flgs="$flgs" ml=S32 tn=perf3board8 fm=coremark th=0
	    [ "$core" = "e5500-64" ] && fmining s=strategy_gcc tag=gcc46,dt46 Htools=$Htools tools=$tools prefix=powerpc-unknown-linux-gnu- flgs="-mcmodel=small $flgs" ml=S64 tn=perf3board8 fm=coremark th=0
	    [ "$core" = "e500v2" ] && fmining s=strategy_gcc tag=gcc46,dt46 Htools=$Htools tools=$tools prefix=powerpc-unknown-linux-gnuspe- flgs="$flgs" ml=S32 tn=perf3board1 fm=coremark th=0
	    [ "$core" = "e6500-32" ] && fmining s=strategy_gcc tag=gcc46,dt46 Htools=$Htools tools=$tools prefix=powerpc-unknown-linux-gnu- flgs="$flgs" ml=S32 tn=perf3board12 fm=coremark th=0
	    [ "$core" = "e6500-64" ] && fmining s=strategy_gcc tag=gcc46,dt46 Htools=$Htools tools=$tools prefix=powerpc-unknown-linux-gnu- flgs="-mcmodel=small $flgs" ml=S64 tn=perf3board12 fm=coremark th=0
	    ;;
	dhrystone)
	    [ "$core" = "e500mc" ] && fmining s=strategy_gcc tag=gcc46,dt46 Htools=$Htools tools=$tools prefix=powerpc-unknown-linux-gnu- flgs="$flgs" ml=S32 tn=perf3board7  bd=/local/edmar/tools_fmining/dhrystone_32bit fm=dhrystone th=0
	    [ "$core" = "e5500-32" ] && fmining s=strategy_gcc tag=gcc46,dt46 Htools=$Htools tools=$tools prefix=powerpc-unknown-linux-gnu- flgs="$flgs" ml=S32 tn=perf3board8  bd=/local/edmar/tools_fmining/dhrystone_32bit fm=dhrystone th=0
	    [ "$core" = "e5500-64" ] && fmining s=strategy_gcc tag=gcc46,dt46 Htools=$Htools tools=$tools prefix=powerpc-unknown-linux-gnu- flgs="-mcmodel=small $flgs" ml=S64 tn=perf3board8 bd=/local/edmar/tools_fmining/dhrystone_64bit fm=dhrystone th=0
	    ;;
	IPMark)
	    [ "$core" = "e500mc" ] && fmining s=strategy_gcc tag=gcc46,dt46,lto Htools=$Htools tools=$tools prefix=powerpc-unknown-linux-gnu- flgs="$flgs" ml=S32 tn=perf3board7 fm=eembc2-IP th=0.01
	    [ "$core" = "e5500-32" ] && fmining s=strategy_gcc tag=gcc46,dt46,lto Htools=$Htools tools=$tools prefix=powerpc-unknown-linux-gnu- flgs="$flgs" ml=S32 tn=perf3board8 fm=eembc2-IP th=0.01
	    [ "$core" = "e5500-64" ] && fmining s=strategy_gcc tag=gcc46,dt46,lto Htools=$Htools tools=$tools prefix=powerpc-unknown-linux-gnu- flgs="-mcmodel=small $flgs" ml=S64 tn=perf3board8 fm=eembc2-IP th=0.01
	    [ "$core" = "e500v2" ] && fmining s=strategy_gcc tag=gcc46,dt46,lto Htools=$Htools tools=$tools prefix=powerpc-unknown-linux-gnuspe- flgs="$flgs" ml=S32 tn=perf3board1 fm=eembc2-IP th=0.01
	    [ "$core" = "e6500-32" ] && fmining s=strategy_gcc tag=gcc46,dt46,lto Htools=$Htools tools=$tools prefix=powerpc-unknown-linux-gnu- flgs="$flgs" ml=S32 tn=perf3board12 fm=eembc2-IP th=0.01 -v -v -v
	    [ "$core" = "e6500-64" ] && fmining s=strategy_gcc tag=gcc46,dt46,lto Htools=$Htools tools=$tools prefix=powerpc-unknown-linux-gnu- flgs="-mcmodel=small $flgs" ml=S64 tn=perf3board12 fm=eembc2-IP th=0.01 -v -v -v
	    ;;
	TCPMark)
	    [ "$core" = "e500mc" ] && fmining s=strategy_gcc tag=gcc46,dt46,lto Htools=$Htools tools=$tools prefix=powerpc-unknown-linux-gnu- flgs="$flgs" ml=S32 tn=perf3board7 fm=eembc2-TCP th=0.01
	    [ "$core" = "e5500-32" ] && fmining s=strategy_gcc tag=gcc46,dt46,lto Htools=$Htools tools=$tools prefix=powerpc-unknown-linux-gnu- flgs="$flgs" ml=S32 tn=perf3board8 fm=eembc2-TCP th=0.01
	    [ "$core" = "e5500-64" ] && fmining s=strategy_gcc tag=gcc46,dt46,lto Htools=$Htools tools=$tools prefix=powerpc-unknown-linux-gnu- flgs="-mcmodel=small $flgs" ml=S64 tn=perf3board8 fm=eembc2-TCP th=0.01
	    [ "$core" = "e500v2" ] && fmining s=strategy_gcc tag=gcc46,dt46,lto Htools=$Htools tools=$tools prefix=powerpc-unknown-linux-gnuspe- flgs="$flgs" ml=S32 tn=perf3board1 fm=eembc2-TCP th=0.01
	    [ "$core" = "e6500-32" ] && fmining s=strategy_gcc tag=gcc46,dt46,lto Htools=$Htools tools=$tools prefix=powerpc-unknown-linux-gnu- flgs="$flgs" ml=S32 tn=perf3board12 fm=eembc2-TCP th=0.01 -v -v -v
	    [ "$core" = "e6500-64" ] && fmining s=strategy_gcc tag=gcc46,dt46,lto Htools=$Htools tools=$tools prefix=powerpc-unknown-linux-gnu- flgs="-mcmodel=small $flgs" ml=S64 tn=perf3board12 fm=eembc2-TCP th=0.01 -v -v -v
	    ;;
	*)
	    echo "Unkonwn argument: $a"
	    exit 1
	    ;;
    esac
done




