#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct {
  char *name;
  int code;
} map;

typedef struct {
  char f_comp;
  char f_exec;
  char f_val;
  char f_iter;
  int dummy;
  double value;
} result;

typedef struct datb {
  result **res;
  char *system;
  struct datb *next;
} database;

enum {
  B_spec2k_gzip,
  B_spec2k_vpr,
  B_spec2k_crafty,
  B_spec2k_parser,
  B_spec2k_eon,
  B_spec2k_gap,
  B_spec2k_vortex,
  B_spec2k_twolf,
  B_spec2k_perlbmk,
  B_spec2k_gcc,
  B_spec2k_mcf,
  B_spec2k_bzip2,
  B_spec2k_wupwise,
  B_spec2k_swim,
  B_spec2k_mgrid,
  B_spec2k_applu,
  B_spec2k_mesa,
  B_spec2k_galgel,
  B_spec2k_art,
  B_spec2k_equake,
  B_spec2k_facerec,
  B_spec2k_ammp,
  B_spec2k_lucas,
  B_spec2k_fma3d,
  B_spec2k_sixtrack,
  B_spec2k_apsi,
  B_spec2k6_perlbench,
  B_spec2k6_bzip2,
  B_spec2k6_gcc,
  B_spec2k6_mcf,
  B_spec2k6_gobmk,
  B_spec2k6_hmmer,
  B_spec2k6_sjeng,
  B_spec2k6_libquantum,
  B_spec2k6_h264ref,
  B_spec2k6_omnetpp,
  B_spec2k6_astar,
  B_spec2k6_xalancbmk,
  B_spec2k6_bwaves,
  B_spec2k6_gamess,
  B_spec2k6_milc,
  B_spec2k6_zeusmp,
  B_spec2k6_gromacs,
  B_spec2k6_cactusADM,
  B_spec2k6_leslie3d,
  B_spec2k6_namd,
  B_spec2k6_dealII,
  B_spec2k6_soplex,
  B_spec2k6_povray,
  B_spec2k6_calculix,
  B_spec2k6_GemsFDTD,
  B_spec2k6_tonto,
  B_spec2k6_lbm,
  B_spec2k6_wrf,
  B_spec2k6_sphinx3,
  B_auto_1_a2time01,
  B_auto_1_aifftr01,
  B_auto_1_aifirf01,
  B_auto_1_aiifft01,
  B_auto_1_basefp01,
  B_auto_1_bitmnp01,
  B_auto_1_cacheb01,
  B_auto_1_canrdr01,
  B_auto_1_idctrn01,
  B_auto_1_iirflt01,
  B_auto_1_matrix01,
  B_auto_1_pntrch01,
  B_auto_1_puwmod01,
  B_auto_1_rspeed01,
  B_auto_1_tblook01,
  B_auto_1_ttsprk01,
  B_auto_1_a2time01_lite,
  B_auto_1_aifftr01_lite,
  B_auto_1_aifirf01_lite,
  B_auto_1_aiifft01_lite,
  B_auto_1_basefp01_lite,
  B_auto_1_bitmnp01_lite,
  B_auto_1_cacheb01_lite,
  B_auto_1_canrdr01_lite,
  B_auto_1_idctrn01_lite,
  B_auto_1_iirflt01_lite,
  B_auto_1_matrix01_lite,
  B_auto_1_pntrch01_lite,
  B_auto_1_puwmod01_lite,
  B_auto_1_rspeed01_lite,
  B_auto_1_tblook01_lite,
  B_auto_1_ttsprk01_lite,
  B_consumer_1_cjpeg,
  B_consumer_1_djpeg,
  B_consumer_1_rgbcmy01,
  B_consumer_1_rgbhpg01,
  B_consumer_1_rgbyiq01,
  B_consumer_1_cjpeg_lite,
  B_consumer_1_djpeg_lite,
  B_consumer_1_rgbcmy01_lite,
  B_consumer_1_rgbhpg01_lite,
  B_consumer_1_rgbyiq01_lite,
  B_net_1_ospf,
  B_net_1_pktflowb1m,
  B_net_1_pktflowb2m,
  B_net_1_pktflowb4m,
  B_net_1_pktflowb512k,
  B_net_1_routelookup,
  B_net_1_ospf_lite,
  B_net_1_pktflowb1m_lite,
  B_net_1_pktflowb2m_lite,
  B_net_1_pktflowb4m_lite,
  B_net_1_pktflowb512k_lite,
  B_net_1_routelookup_lite,
  B_telecom_1_autcor00data_1,
  B_telecom_1_conven00data_2,
  B_telecom_1_fbital00data_2,
  B_telecom_1_fft00data_2,
  B_telecom_1_viterb00data_3,
  B_telecom_1_autcor00data_2,
  B_telecom_1_conven00data_3,
  B_telecom_1_fbital00data_3,
  B_telecom_1_fft00data_3,
  B_telecom_1_viterb00data_4,
  B_telecom_1_autcor00data_3,
  B_telecom_1_fbital00data_6,
  B_telecom_1_viterb00data_1,
  B_telecom_1_conven00data_1,
  B_telecom_1_fft00data_1,
  B_telecom_1_viterb00data_2,
  B_telecom_1_autcor00data_1_lite,
  B_telecom_1_conven00data_2_lite,
  B_telecom_1_fbital00data_2_lite,
  B_telecom_1_fft00data_2_lite,
  B_telecom_1_viterb00data_3_lite,
  B_telecom_1_autcor00data_2_lite,
  B_telecom_1_conven00data_3_lite,
  B_telecom_1_fbital00data_3_lite,
  B_telecom_1_fft00data_3_lite,
  B_telecom_1_viterb00data_4_lite,
  B_telecom_1_autcor00data_3_lite,
  B_telecom_1_fbital00data_6_lite,
  B_telecom_1_viterb00data_1_lite,
  B_telecom_1_conven00data_1_lite,
  B_telecom_1_fft00data_1_lite,
  B_telecom_1_viterb00data_2_lite,
  B_office_1_dither01,
  B_office_1_rotate01,
  B_office_1_text01,
  B_office_1_dither01_lite,
  B_office_1_rotate01_lite,
  B_office_1_text01_lite,
  B_consumer_2_aes_lite,
  B_consumer_2_mp2decoddata5_lite,
  B_consumer_2_mp3playerfixeddata2_lite,
  B_consumer_2_rgbcmykv2data1_lite,
  B_consumer_2_cjpegv2data1_lite,
  B_consumer_2_mp2decodf32psnr1_lite,
  B_consumer_2_mp3playerfixeddata3_lite,
  B_consumer_2_rgbcmykv2data2_lite,
  B_consumer_2_cjpegv2data2_lite,
  B_consumer_2_mp2decodf32psnr2_lite,
  B_consumer_2_mp3playerfixeddata4_lite,
  B_consumer_2_rgbcmykv2data3_lite,
  B_consumer_2_cjpegv2data3_lite,
  B_consumer_2_mp2decodf32psnr3_lite,
  B_consumer_2_mp3playerfixeddata5_lite,
  B_consumer_2_rgbcmykv2data4_lite,
  B_consumer_2_cjpegv2data4_lite,
  B_consumer_2_mp2decodf32psnr4_lite,
  B_consumer_2_mp4decodedata1_lite,
  B_consumer_2_rgbcmykv2data5_lite,
  B_consumer_2_cjpegv2data5_lite,
  B_consumer_2_mp2decodf32psnr5_lite,
  B_consumer_2_mp4decodedata2_lite,
  B_consumer_2_rgbcmykv2data6_lite,
  B_consumer_2_cjpegv2data6_lite,
  B_consumer_2_mp2decodfixpsnr1_lite,
  B_consumer_2_mp4decodedata3_lite,
  B_consumer_2_rgbcmykv2data7_lite,
  B_consumer_2_cjpegv2data7_lite,
  B_consumer_2_mp2decodfixpsnr2_lite,
  B_consumer_2_mp4decodedata4_lite,
  B_consumer_2_rgbhpgv2data1_lite,
  B_consumer_2_des_lite,
  B_consumer_2_mp2decodfixpsnr3_lite,
  B_consumer_2_mp4decodedata5_lite,
  B_consumer_2_rgbhpgv2data2_lite,
  B_consumer_2_djpegv2data1_lite,
  B_consumer_2_mp2decodfixpsnr4_lite,
  B_consumer_2_mp4decodepsnr1_lite,
  B_consumer_2_rgbhpgv2data3_lite,
  B_consumer_2_djpegv2data2_lite,
  B_consumer_2_mp2decodfixpsnr5_lite,
  B_consumer_2_mp4decodepsnr2_lite,
  B_consumer_2_rgbhpgv2data4_lite,
  B_consumer_2_djpegv2data3_lite,
  B_consumer_2_mp2enf32data1_lite,
  B_consumer_2_mp4decodepsnr3_lite,
  B_consumer_2_rgbhpgv2data5_lite,
  B_consumer_2_djpegv2data4_lite,
  B_consumer_2_mp2enf32data2_lite,
  B_consumer_2_mp4decodepsnr4_lite,
  B_consumer_2_rgbhpgv2data6_lite,
  B_consumer_2_djpegv2data5_lite,
  B_consumer_2_mp2enf32data3_lite,
  B_consumer_2_mp4decodepsnr5_lite,
  B_consumer_2_rgbhpgv2data7_lite,
  B_consumer_2_djpegv2data6_lite,
  B_consumer_2_mp2enf32data4_lite,
  B_consumer_2_mp4decodepsnr_lite,
  B_consumer_2_rgbyiqv2data1_lite,
  B_consumer_2_djpegv2data7_lite,
  B_consumer_2_mp2enf32data5_lite,
  B_consumer_2_mp4encodedata1_lite,
  B_consumer_2_rgbyiqv2data2_lite,
  B_consumer_2_mp2enfixdata1_lite,
  B_consumer_2_mp4encodedata2_lite,
  B_consumer_2_rgbyiqv2data3_lite,
  B_consumer_2_huffde_lite,
  B_consumer_2_mp2enfixdata2_lite,
  B_consumer_2_mp4encodedata3_lite,
  B_consumer_2_rgbyiqv2data4_lite,
  B_consumer_2_mp2decoddata1_lite,
  B_consumer_2_mp2enfixdata3_lite,
  B_consumer_2_mp4encodedata4_lite,
  B_consumer_2_rgbyiqv2data5_lite,
  B_consumer_2_mp2decoddata2_lite,
  B_consumer_2_mp2enfixdata4_lite,
  B_consumer_2_mp4encodedata5_lite,
  B_consumer_2_rgbyiqv2data6_lite,
  B_consumer_2_mp2decoddata3_lite,
  B_consumer_2_mp2enfixdata5_lite,
  B_consumer_2_mpeg2decpsnr_lite,
  B_consumer_2_rgbyiqv2data7_lite,
  B_consumer_2_mp2decoddata4_lite,
  B_consumer_2_mp3playerfixeddata1_lite,
  B_consumer_2_psnr_lite,
  B_consumer_2_rsa_lite,
  B_net_2_ip_pktcheckb4m_lite,
  B_net_2_nat_lite,
  B_net_2_routelookup_lite,
  B_net_2_tcpmixed_lite,
  B_net_2_ip_pktcheckb1m_lite,
  B_net_2_ip_pktcheckb512k_lite,
  B_net_2_ospfv2_lite,
  B_net_2_tcpbulk_lite,
  B_net_2_ip_pktcheckb2m_lite,
  B_net_2_ip_reassembly_lite,
  B_net_2_qos_lite,
  B_net_2_tcpjumbo_lite,
  B_office_2_bezierv2fixed_d2_lite,
  B_office_2_bezierv2fixed_d3_lite,
  B_office_2_bezierv2fixed_d4_lite,
  B_office_2_bezierv2float_d2_lite,
  B_office_2_bezierv2float_d3_lite,
  B_office_2_bezierv2float_d4_lite,
  B_office_2_textv2_d2_lite,
  B_office_2_textv2_d3_lite,
  B_office_2_textv2_d4_lite,
  B_office_2_ditherv2_d2_lite,
  B_office_2_ditherv2_d3_lite,
  B_office_2_ditherv2_d4_lite,
  B_office_2_ditherv2_d5_lite,
  B_office_2_ditherv2_d6_lite,
  B_office_2_ditherv2_d7_lite,
  B_office_2_ditherv2_d8_lite,
  B_office_2_ditherv2_d9_lite,
  B_office_2_ditherv2_d10_lite,
  B_office_2_ditherv2_d11_lite,
  B_office_2_rotatev2_d2_lite,
  B_office_2_rotatev2_d3_lite,
  B_office_2_rotatev2_d4_lite,
  B_office_2_rotatev2_d5_lite,
  B_office_2_rotatev2_d6_lite,
  B_office_2_rotatev2_d7_lite,
  B_office_2_rotatev2_d8_lite,
  B_office_2_rotatev2_d9_lite,
  B_office_2_rotatev2_d10_lite,
  B_office_2_rotatev2_d11_lite,
  B_coremark,
  B_dhrystone,
  B_nbench,
  B_whetstone,
  B_stanford,
  B_linpack,
  B_nas_applu,
  B_nas_appsp,
  B_nas_buk,
  B_nas_cgm,
  B_nas_embar,
  B_nas_fftpde,
  B_perfect_adm,
  B_perfect_arc2d,
  B_perfect_dyfesm,
  B_perfect_flo52,
  B_perfect_mdg,
  B_perfect_mg3d,
  B_perfect_qcd,
  B_perfect_trfd,
  B_smalltests_8q,
  B_smalltests_array,
  B_smalltests_BYTE_fp,
  B_smalltests_call2,
  B_smalltests_call4,
  B_smalltests_cf,
  B_smalltests_cvt,
  B_smalltests_gim,
  B_smalltests_init,
  B_smalltests_neg,
  B_smalltests_rel,
  B_smalltests_spill,
  B_smalltests_stdarg,
  B_smalltests_struct2,
  B_smalltests_switch,
  B_smalltests_yacc,
  B_smalltests_arg,
  B_smalltests_bigframe,
  B_smalltests_call1,
  B_smalltests_call3,
  B_smalltests_call5,
  B_smalltests_copy,
  B_smalltests_fltconv,
  B_smalltests_incr,
  B_smalltests_limits,
  B_smalltests_sort,
  B_smalltests_sr,
  B_smalltests_store,
  B_smalltests_struct,
  B_smalltests_wf1,
  B_last
};

enum {
  C_603e_32,
  C_603e_nof,
  C_603e_S32,
  C_603e_Snof,
  C_e300c2_32,
  C_e300c2_S32,
  C_e300c3_32,
  C_e300c3_nof,
  C_e300c3_S32,
  C_e300c3_Snof,
  C_e500v1_32,
  C_e500v1_nof,
  C_e500v1_S32,
  C_e500v1_Snof,
  C_e500v2_32,
  C_e500v2_nof,
  C_e500v2_S32,
  C_e500v2_Snof,
  C_e500mc_32,
  C_e500mc_nof,
  C_e500mc_S32,
  C_e500mc_Snof,
  C_e600_32,
  C_e600_nof,
  C_e600_S32,
  C_e600_Snof,
  C_e5500_32,
  C_e5500_64,
  C_e5500_nof,
  C_e5500_S32,
  C_e5500_S64,
  C_e5500_Snof,
  C_e6500_32,
  C_e6500_64,
  C_e6500_nof,
  C_e6500_S32,
  C_e6500_S64,
  C_e6500_Snof,
  C_last
};

map bmk[] = {
  {"spec2k.gzip", B_spec2k_gzip},
  {"spec2k.vpr", B_spec2k_vpr},
  {"spec2k.crafty", B_spec2k_crafty},
  {"spec2k.parser", B_spec2k_parser},
  {"spec2k.eon", B_spec2k_eon},
  {"spec2k.gap", B_spec2k_gap},
  {"spec2k.vortex", B_spec2k_vortex},
  {"spec2k.twolf", B_spec2k_twolf},
  {"spec2k.perlbmk", B_spec2k_perlbmk},
  {"spec2k.gcc", B_spec2k_gcc},
  {"spec2k.mcf", B_spec2k_mcf},
  {"spec2k.bzip2", B_spec2k_bzip2},
  {"spec2k.wupwise", B_spec2k_wupwise},
  {"spec2k.swim", B_spec2k_swim},
  {"spec2k.mgrid", B_spec2k_mgrid},
  {"spec2k.applu", B_spec2k_applu},
  {"spec2k.mesa", B_spec2k_mesa},
  {"spec2k.galgel", B_spec2k_galgel},
  {"spec2k.art", B_spec2k_art},
  {"spec2k.equake", B_spec2k_equake},
  {"spec2k.facerec", B_spec2k_facerec},
  {"spec2k.ammp", B_spec2k_ammp},
  {"spec2k.lucas", B_spec2k_lucas},
  {"spec2k.fma3d", B_spec2k_fma3d},
  {"spec2k.sixtrack", B_spec2k_sixtrack},
  {"spec2k.apsi", B_spec2k_apsi},
  {"spec2k6.perlbench", B_spec2k6_perlbench},
  {"spec2k6.bzip2", B_spec2k6_bzip2},
  {"spec2k6.gcc", B_spec2k6_gcc},
  {"spec2k6.mcf", B_spec2k6_mcf},
  {"spec2k6.gobmk", B_spec2k6_gobmk},
  {"spec2k6.hmmer", B_spec2k6_hmmer},
  {"spec2k6.sjeng", B_spec2k6_sjeng},
  {"spec2k6.libquantum", B_spec2k6_libquantum},
  {"spec2k6.h264ref", B_spec2k6_h264ref},
  {"spec2k6.omnetpp", B_spec2k6_omnetpp},
  {"spec2k6.astar", B_spec2k6_astar},
  {"spec2k6.xalancbmk", B_spec2k6_xalancbmk},
  {"spec2k6.bwaves", B_spec2k6_bwaves},
  {"spec2k6.gamess", B_spec2k6_gamess},
  {"spec2k6.milc", B_spec2k6_milc},
  {"spec2k6.zeusmp", B_spec2k6_zeusmp},
  {"spec2k6.gromacs", B_spec2k6_gromacs},
  {"spec2k6.cactusADM", B_spec2k6_cactusADM},
  {"spec2k6.leslie3d", B_spec2k6_leslie3d},
  {"spec2k6.namd", B_spec2k6_namd},
  {"spec2k6.dealII", B_spec2k6_dealII},
  {"spec2k6.soplex", B_spec2k6_soplex},
  {"spec2k6.povray", B_spec2k6_povray},
  {"spec2k6.calculix", B_spec2k6_calculix},
  {"spec2k6.GemsFDTD", B_spec2k6_GemsFDTD},
  {"spec2k6.tonto", B_spec2k6_tonto},
  {"spec2k6.lbm", B_spec2k6_lbm},
  {"spec2k6.wrf", B_spec2k6_wrf},
  {"spec2k6.sphinx3", B_spec2k6_sphinx3},
  {"auto-1.a2time01", B_auto_1_a2time01},
  {"auto-1.aifftr01", B_auto_1_aifftr01},
  {"auto-1.aifirf01", B_auto_1_aifirf01},
  {"auto-1.aiifft01", B_auto_1_aiifft01},
  {"auto-1.basefp01", B_auto_1_basefp01},
  {"auto-1.bitmnp01", B_auto_1_bitmnp01},
  {"auto-1.cacheb01", B_auto_1_cacheb01},
  {"auto-1.canrdr01", B_auto_1_canrdr01},
  {"auto-1.idctrn01", B_auto_1_idctrn01},
  {"auto-1.iirflt01", B_auto_1_iirflt01},
  {"auto-1.matrix01", B_auto_1_matrix01},
  {"auto-1.pntrch01", B_auto_1_pntrch01},
  {"auto-1.puwmod01", B_auto_1_puwmod01},
  {"auto-1.rspeed01", B_auto_1_rspeed01},
  {"auto-1.tblook01", B_auto_1_tblook01},
  {"auto-1.ttsprk01", B_auto_1_ttsprk01},
  {"auto-1.a2time01_lite", B_auto_1_a2time01_lite},
  {"auto-1.aifftr01_lite", B_auto_1_aifftr01_lite},
  {"auto-1.aifirf01_lite", B_auto_1_aifirf01_lite},
  {"auto-1.aiifft01_lite", B_auto_1_aiifft01_lite},
  {"auto-1.basefp01_lite", B_auto_1_basefp01_lite},
  {"auto-1.bitmnp01_lite", B_auto_1_bitmnp01_lite},
  {"auto-1.cacheb01_lite", B_auto_1_cacheb01_lite},
  {"auto-1.canrdr01_lite", B_auto_1_canrdr01_lite},
  {"auto-1.idctrn01_lite", B_auto_1_idctrn01_lite},
  {"auto-1.iirflt01_lite", B_auto_1_iirflt01_lite},
  {"auto-1.matrix01_lite", B_auto_1_matrix01_lite},
  {"auto-1.pntrch01_lite", B_auto_1_pntrch01_lite},
  {"auto-1.puwmod01_lite", B_auto_1_puwmod01_lite},
  {"auto-1.rspeed01_lite", B_auto_1_rspeed01_lite},
  {"auto-1.tblook01_lite", B_auto_1_tblook01_lite},
  {"auto-1.ttsprk01_lite", B_auto_1_ttsprk01_lite},
  {"consumer-1.cjpeg", B_consumer_1_cjpeg},
  {"consumer-1.djpeg", B_consumer_1_djpeg},
  {"consumer-1.rgbcmy01", B_consumer_1_rgbcmy01},
  {"consumer-1.rgbhpg01", B_consumer_1_rgbhpg01},
  {"consumer-1.rgbyiq01", B_consumer_1_rgbyiq01},
  {"consumer-1.cjpeg_lite", B_consumer_1_cjpeg_lite},
  {"consumer-1.djpeg_lite", B_consumer_1_djpeg_lite},
  {"consumer-1.rgbcmy01_lite", B_consumer_1_rgbcmy01_lite},
  {"consumer-1.rgbhpg01_lite", B_consumer_1_rgbhpg01_lite},
  {"consumer-1.rgbyiq01_lite", B_consumer_1_rgbyiq01_lite},
  {"net-1.ospf", B_net_1_ospf},
  {"net-1.pktflowb1m", B_net_1_pktflowb1m},
  {"net-1.pktflowb2m", B_net_1_pktflowb2m},
  {"net-1.pktflowb4m", B_net_1_pktflowb4m},
  {"net-1.pktflowb512k", B_net_1_pktflowb512k},
  {"net-1.routelookup", B_net_1_routelookup},
  {"net-1.ospf_lite", B_net_1_ospf_lite},
  {"net-1.pktflowb1m_lite", B_net_1_pktflowb1m_lite},
  {"net-1.pktflowb2m_lite", B_net_1_pktflowb2m_lite},
  {"net-1.pktflowb4m_lite", B_net_1_pktflowb4m_lite},
  {"net-1.pktflowb512k_lite", B_net_1_pktflowb512k_lite},
  {"net-1.routelookup_lite", B_net_1_routelookup_lite},
  {"telecom-1.autcor00data_1", B_telecom_1_autcor00data_1},
  {"telecom-1.conven00data_2", B_telecom_1_conven00data_2},
  {"telecom-1.fbital00data_2", B_telecom_1_fbital00data_2},
  {"telecom-1.fft00data_2", B_telecom_1_fft00data_2},
  {"telecom-1.viterb00data_3", B_telecom_1_viterb00data_3},
  {"telecom-1.autcor00data_2", B_telecom_1_autcor00data_2},
  {"telecom-1.conven00data_3", B_telecom_1_conven00data_3},
  {"telecom-1.fbital00data_3", B_telecom_1_fbital00data_3},
  {"telecom-1.fft00data_3", B_telecom_1_fft00data_3},
  {"telecom-1.viterb00data_4", B_telecom_1_viterb00data_4},
  {"telecom-1.autcor00data_3", B_telecom_1_autcor00data_3},
  {"telecom-1.fbital00data_6", B_telecom_1_fbital00data_6},
  {"telecom-1.viterb00data_1", B_telecom_1_viterb00data_1},
  {"telecom-1.conven00data_1", B_telecom_1_conven00data_1},
  {"telecom-1.fft00data_1", B_telecom_1_fft00data_1},
  {"telecom-1.viterb00data_2", B_telecom_1_viterb00data_2},
  {"telecom-1.autcor00data_1_lite", B_telecom_1_autcor00data_1_lite},
  {"telecom-1.conven00data_2_lite", B_telecom_1_conven00data_2_lite},
  {"telecom-1.fbital00data_2_lite", B_telecom_1_fbital00data_2_lite},
  {"telecom-1.fft00data_2_lite", B_telecom_1_fft00data_2_lite},
  {"telecom-1.viterb00data_3_lite", B_telecom_1_viterb00data_3_lite},
  {"telecom-1.autcor00data_2_lite", B_telecom_1_autcor00data_2_lite},
  {"telecom-1.conven00data_3_lite", B_telecom_1_conven00data_3_lite},
  {"telecom-1.fbital00data_3_lite", B_telecom_1_fbital00data_3_lite},
  {"telecom-1.fft00data_3_lite", B_telecom_1_fft00data_3_lite},
  {"telecom-1.viterb00data_4_lite", B_telecom_1_viterb00data_4_lite},
  {"telecom-1.autcor00data_3_lite", B_telecom_1_autcor00data_3_lite},
  {"telecom-1.fbital00data_6_lite", B_telecom_1_fbital00data_6_lite},
  {"telecom-1.viterb00data_1_lite", B_telecom_1_viterb00data_1_lite},
  {"telecom-1.conven00data_1_lite", B_telecom_1_conven00data_1_lite},
  {"telecom-1.fft00data_1_lite", B_telecom_1_fft00data_1_lite},
  {"telecom-1.viterb00data_2_lite", B_telecom_1_viterb00data_2_lite},
  {"office-1.dither01", B_office_1_dither01},
  {"office-1.rotate01", B_office_1_rotate01},
  {"office-1.text01", B_office_1_text01},
  {"office-1.dither01_lite", B_office_1_dither01_lite},
  {"office-1.rotate01_lite", B_office_1_rotate01_lite},
  {"office-1.text01_lite", B_office_1_text01_lite},
  {"consumer-2.aes_lite", B_consumer_2_aes_lite},
  {"consumer-2.mp2decoddata5_lite", B_consumer_2_mp2decoddata5_lite},
  {"consumer-2.mp3playerfixeddata2_lite", B_consumer_2_mp3playerfixeddata2_lite},
  {"consumer-2.rgbcmykv2data1_lite", B_consumer_2_rgbcmykv2data1_lite},
  {"consumer-2.cjpegv2data1_lite", B_consumer_2_cjpegv2data1_lite},
  {"consumer-2.mp2decodf32psnr1_lite", B_consumer_2_mp2decodf32psnr1_lite},
  {"consumer-2.mp3playerfixeddata3_lite", B_consumer_2_mp3playerfixeddata3_lite},
  {"consumer-2.rgbcmykv2data2_lite", B_consumer_2_rgbcmykv2data2_lite},
  {"consumer-2.cjpegv2data2_lite", B_consumer_2_cjpegv2data2_lite},
  {"consumer-2.mp2decodf32psnr2_lite", B_consumer_2_mp2decodf32psnr2_lite},
  {"consumer-2.mp3playerfixeddata4_lite", B_consumer_2_mp3playerfixeddata4_lite},
  {"consumer-2.rgbcmykv2data3_lite", B_consumer_2_rgbcmykv2data3_lite},
  {"consumer-2.cjpegv2data3_lite", B_consumer_2_cjpegv2data3_lite},
  {"consumer-2.mp2decodf32psnr3_lite", B_consumer_2_mp2decodf32psnr3_lite},
  {"consumer-2.mp3playerfixeddata5_lite", B_consumer_2_mp3playerfixeddata5_lite},
  {"consumer-2.rgbcmykv2data4_lite", B_consumer_2_rgbcmykv2data4_lite},
  {"consumer-2.cjpegv2data4_lite", B_consumer_2_cjpegv2data4_lite},
  {"consumer-2.mp2decodf32psnr4_lite", B_consumer_2_mp2decodf32psnr4_lite},
  {"consumer-2.mp4decodedata1_lite", B_consumer_2_mp4decodedata1_lite},
  {"consumer-2.rgbcmykv2data5_lite", B_consumer_2_rgbcmykv2data5_lite},
  {"consumer-2.cjpegv2data5_lite", B_consumer_2_cjpegv2data5_lite},
  {"consumer-2.mp2decodf32psnr5_lite", B_consumer_2_mp2decodf32psnr5_lite},
  {"consumer-2.mp4decodedata2_lite", B_consumer_2_mp4decodedata2_lite},
  {"consumer-2.rgbcmykv2data6_lite", B_consumer_2_rgbcmykv2data6_lite},
  {"consumer-2.cjpegv2data6_lite", B_consumer_2_cjpegv2data6_lite},
  {"consumer-2.mp2decodfixpsnr1_lite", B_consumer_2_mp2decodfixpsnr1_lite},
  {"consumer-2.mp4decodedata3_lite", B_consumer_2_mp4decodedata3_lite},
  {"consumer-2.rgbcmykv2data7_lite", B_consumer_2_rgbcmykv2data7_lite},
  {"consumer-2.cjpegv2data7_lite", B_consumer_2_cjpegv2data7_lite},
  {"consumer-2.mp2decodfixpsnr2_lite", B_consumer_2_mp2decodfixpsnr2_lite},
  {"consumer-2.mp4decodedata4_lite", B_consumer_2_mp4decodedata4_lite},
  {"consumer-2.rgbhpgv2data1_lite", B_consumer_2_rgbhpgv2data1_lite},
  {"consumer-2.des_lite", B_consumer_2_des_lite},
  {"consumer-2.mp2decodfixpsnr3_lite", B_consumer_2_mp2decodfixpsnr3_lite},
  {"consumer-2.mp4decodedata5_lite", B_consumer_2_mp4decodedata5_lite},
  {"consumer-2.rgbhpgv2data2_lite", B_consumer_2_rgbhpgv2data2_lite},
  {"consumer-2.djpegv2data1_lite", B_consumer_2_djpegv2data1_lite},
  {"consumer-2.mp2decodfixpsnr4_lite", B_consumer_2_mp2decodfixpsnr4_lite},
  {"consumer-2.mp4decodepsnr1_lite", B_consumer_2_mp4decodepsnr1_lite},
  {"consumer-2.rgbhpgv2data3_lite", B_consumer_2_rgbhpgv2data3_lite},
  {"consumer-2.djpegv2data2_lite", B_consumer_2_djpegv2data2_lite},
  {"consumer-2.mp2decodfixpsnr5_lite", B_consumer_2_mp2decodfixpsnr5_lite},
  {"consumer-2.mp4decodepsnr2_lite", B_consumer_2_mp4decodepsnr2_lite},
  {"consumer-2.rgbhpgv2data4_lite", B_consumer_2_rgbhpgv2data4_lite},
  {"consumer-2.djpegv2data3_lite", B_consumer_2_djpegv2data3_lite},
  {"consumer-2.mp2enf32data1_lite", B_consumer_2_mp2enf32data1_lite},
  {"consumer-2.mp4decodepsnr3_lite", B_consumer_2_mp4decodepsnr3_lite},
  {"consumer-2.rgbhpgv2data5_lite", B_consumer_2_rgbhpgv2data5_lite},
  {"consumer-2.djpegv2data4_lite", B_consumer_2_djpegv2data4_lite},
  {"consumer-2.mp2enf32data2_lite", B_consumer_2_mp2enf32data2_lite},
  {"consumer-2.mp4decodepsnr4_lite", B_consumer_2_mp4decodepsnr4_lite},
  {"consumer-2.rgbhpgv2data6_lite", B_consumer_2_rgbhpgv2data6_lite},
  {"consumer-2.djpegv2data5_lite", B_consumer_2_djpegv2data5_lite},
  {"consumer-2.mp2enf32data3_lite", B_consumer_2_mp2enf32data3_lite},
  {"consumer-2.mp4decodepsnr5_lite", B_consumer_2_mp4decodepsnr5_lite},
  {"consumer-2.rgbhpgv2data7_lite", B_consumer_2_rgbhpgv2data7_lite},
  {"consumer-2.djpegv2data6_lite", B_consumer_2_djpegv2data6_lite},
  {"consumer-2.mp2enf32data4_lite", B_consumer_2_mp2enf32data4_lite},
  {"consumer-2.mp4decodepsnr_lite", B_consumer_2_mp4decodepsnr_lite},
  {"consumer-2.rgbyiqv2data1_lite", B_consumer_2_rgbyiqv2data1_lite},
  {"consumer-2.djpegv2data7_lite", B_consumer_2_djpegv2data7_lite},
  {"consumer-2.mp2enf32data5_lite", B_consumer_2_mp2enf32data5_lite},
  {"consumer-2.mp4encodedata1_lite", B_consumer_2_mp4encodedata1_lite},
  {"consumer-2.rgbyiqv2data2_lite", B_consumer_2_rgbyiqv2data2_lite},
  {"consumer-2.mp2enfixdata1_lite", B_consumer_2_mp2enfixdata1_lite},
  {"consumer-2.mp4encodedata2_lite", B_consumer_2_mp4encodedata2_lite},
  {"consumer-2.rgbyiqv2data3_lite", B_consumer_2_rgbyiqv2data3_lite},
  {"consumer-2.huffde_lite", B_consumer_2_huffde_lite},
  {"consumer-2.mp2enfixdata2_lite", B_consumer_2_mp2enfixdata2_lite},
  {"consumer-2.mp4encodedata3_lite", B_consumer_2_mp4encodedata3_lite},
  {"consumer-2.rgbyiqv2data4_lite", B_consumer_2_rgbyiqv2data4_lite},
  {"consumer-2.mp2decoddata1_lite", B_consumer_2_mp2decoddata1_lite},
  {"consumer-2.mp2enfixdata3_lite", B_consumer_2_mp2enfixdata3_lite},
  {"consumer-2.mp4encodedata4_lite", B_consumer_2_mp4encodedata4_lite},
  {"consumer-2.rgbyiqv2data5_lite", B_consumer_2_rgbyiqv2data5_lite},
  {"consumer-2.mp2decoddata2_lite", B_consumer_2_mp2decoddata2_lite},
  {"consumer-2.mp2enfixdata4_lite", B_consumer_2_mp2enfixdata4_lite},
  {"consumer-2.mp4encodedata5_lite", B_consumer_2_mp4encodedata5_lite},
  {"consumer-2.rgbyiqv2data6_lite", B_consumer_2_rgbyiqv2data6_lite},
  {"consumer-2.mp2decoddata3_lite", B_consumer_2_mp2decoddata3_lite},
  {"consumer-2.mp2enfixdata5_lite", B_consumer_2_mp2enfixdata5_lite},
  {"consumer-2.mpeg2decpsnr_lite", B_consumer_2_mpeg2decpsnr_lite},
  {"consumer-2.rgbyiqv2data7_lite", B_consumer_2_rgbyiqv2data7_lite},
  {"consumer-2.mp2decoddata4_lite", B_consumer_2_mp2decoddata4_lite},
  {"consumer-2.mp3playerfixeddata1_lite", B_consumer_2_mp3playerfixeddata1_lite},
  {"consumer-2.psnr_lite", B_consumer_2_psnr_lite},
  {"consumer-2.rsa_lite", B_consumer_2_rsa_lite},
  {"net-2.ip_pktcheckb4m_lite", B_net_2_ip_pktcheckb4m_lite},
  {"net-2.nat_lite", B_net_2_nat_lite},
  {"net-2.routelookup_lite", B_net_2_routelookup_lite},
  {"net-2.tcpmixed_lite", B_net_2_tcpmixed_lite},
  {"net-2.ip_pktcheckb1m_lite", B_net_2_ip_pktcheckb1m_lite},
  {"net-2.ip_pktcheckb512k_lite", B_net_2_ip_pktcheckb512k_lite},
  {"net-2.ospfv2_lite", B_net_2_ospfv2_lite},
  {"net-2.tcpbulk_lite", B_net_2_tcpbulk_lite},
  {"net-2.ip_pktcheckb2m_lite", B_net_2_ip_pktcheckb2m_lite},
  {"net-2.ip_reassembly_lite", B_net_2_ip_reassembly_lite},
  {"net-2.qos_lite", B_net_2_qos_lite},
  {"net-2.tcpjumbo_lite", B_net_2_tcpjumbo_lite},
  {"office-2.bezierv2fixed.d2_lite", B_office_2_bezierv2fixed_d2_lite},
  {"office-2.bezierv2fixed.d3_lite", B_office_2_bezierv2fixed_d3_lite},
  {"office-2.bezierv2fixed.d4_lite", B_office_2_bezierv2fixed_d4_lite},
  {"office-2.bezierv2float.d2_lite", B_office_2_bezierv2float_d2_lite},
  {"office-2.bezierv2float.d3_lite", B_office_2_bezierv2float_d3_lite},
  {"office-2.bezierv2float.d4_lite", B_office_2_bezierv2float_d4_lite},
  {"office-2.textv2.d2_lite", B_office_2_textv2_d2_lite},
  {"office-2.textv2.d3_lite", B_office_2_textv2_d3_lite},
  {"office-2.textv2.d4_lite", B_office_2_textv2_d4_lite},
  {"office-2.ditherv2.d2_lite", B_office_2_ditherv2_d2_lite},
  {"office-2.ditherv2.d3_lite", B_office_2_ditherv2_d3_lite},
  {"office-2.ditherv2.d4_lite", B_office_2_ditherv2_d4_lite},
  {"office-2.ditherv2.d5_lite", B_office_2_ditherv2_d5_lite},
  {"office-2.ditherv2.d6_lite", B_office_2_ditherv2_d6_lite},
  {"office-2.ditherv2.d7_lite", B_office_2_ditherv2_d7_lite},
  {"office-2.ditherv2.d8_lite", B_office_2_ditherv2_d8_lite},
  {"office-2.ditherv2.d9_lite", B_office_2_ditherv2_d9_lite},
  {"office-2.ditherv2.d10_lite", B_office_2_ditherv2_d10_lite},
  {"office-2.ditherv2.d11_lite", B_office_2_ditherv2_d11_lite},
  {"office-2.rotatev2.d2_lite", B_office_2_rotatev2_d2_lite},
  {"office-2.rotatev2.d3_lite", B_office_2_rotatev2_d3_lite},
  {"office-2.rotatev2.d4_lite", B_office_2_rotatev2_d4_lite},
  {"office-2.rotatev2.d5_lite", B_office_2_rotatev2_d5_lite},
  {"office-2.rotatev2.d6_lite", B_office_2_rotatev2_d6_lite},
  {"office-2.rotatev2.d7_lite", B_office_2_rotatev2_d7_lite},
  {"office-2.rotatev2.d8_lite", B_office_2_rotatev2_d8_lite},
  {"office-2.rotatev2.d9_lite", B_office_2_rotatev2_d9_lite},
  {"office-2.rotatev2.d10_lite", B_office_2_rotatev2_d10_lite},
  {"office-2.rotatev2.d11_lite", B_office_2_rotatev2_d11_lite},
  {"coremark", B_coremark},
  {"dhrystone", B_dhrystone},
  {"nbench", B_nbench},
  {"whetstone", B_whetstone},
  {"stanford", B_stanford},
  {"linpack", B_linpack},
  {"nas.applu", B_nas_applu},
  {"nas.appsp", B_nas_appsp},
  {"nas.buk", B_nas_buk},
  {"nas.cgm", B_nas_cgm},
  {"nas.embar", B_nas_embar},
  {"nas.fftpde", B_nas_fftpde},
  {"perfect.adm", B_perfect_adm},
  {"perfect.arc2d", B_perfect_arc2d},
  {"perfect.dyfesm", B_perfect_dyfesm},
  {"perfect.flo52", B_perfect_flo52},
  {"perfect.mdg", B_perfect_mdg},
  {"perfect.mg3d", B_perfect_mg3d},
  {"perfect.qcd", B_perfect_qcd},
  {"perfect.trfd", B_perfect_trfd},
  {"smalltests.8q", B_smalltests_8q},
  {"smalltests.array", B_smalltests_array},
  {"smalltests.BYTE_fp", B_smalltests_BYTE_fp},
  {"smalltests.call2", B_smalltests_call2},
  {"smalltests.call4", B_smalltests_call4},
  {"smalltests.cf", B_smalltests_cf},
  {"smalltests.cvt", B_smalltests_cvt},
  {"smalltests.gim", B_smalltests_gim},
  {"smalltests.init", B_smalltests_init},
  {"smalltests.neg", B_smalltests_neg},
  {"smalltests.rel", B_smalltests_rel},
  {"smalltests.spill", B_smalltests_spill},
  {"smalltests.stdarg", B_smalltests_stdarg},
  {"smalltests.struct2", B_smalltests_struct2},
  {"smalltests.switch", B_smalltests_switch},
  {"smalltests.yacc", B_smalltests_yacc},
  {"smalltests.arg", B_smalltests_arg},
  {"smalltests.bigframe", B_smalltests_bigframe},
  {"smalltests.call1", B_smalltests_call1},
  {"smalltests.call3", B_smalltests_call3},
  {"smalltests.call5", B_smalltests_call5},
  {"smalltests.copy", B_smalltests_copy},
  {"smalltests.fltconv", B_smalltests_fltconv},
  {"smalltests.incr", B_smalltests_incr},
  {"smalltests.limits", B_smalltests_limits},
  {"smalltests.sort", B_smalltests_sort},
  {"smalltests.sr", B_smalltests_sr},
  {"smalltests.store", B_smalltests_store},
  {"smalltests.struct", B_smalltests_struct},
  {"smalltests.wf1", B_smalltests_wf1},
};

map yes_no[] = {
  {"Y", 1},
  {"N", 0}
};

map core[] = {
  {"603e.32", C_603e_32},
  {"603e.nof", C_603e_nof},
  {"603e.S32", C_603e_S32},
  {"603e.Snof", C_603e_Snof},
  {"e300c2.32", C_e300c2_32},
  {"e300c2.S32", C_e300c2_S32},
  {"e300c3.32", C_e300c3_32},
  {"e300c3.nof", C_e300c3_nof},
  {"e300c3.S32", C_e300c3_S32},
  {"e300c3.Snof", C_e300c3_Snof},
  {"e500v1.32", C_e500v1_32},
  {"e500v1.nof", C_e500v1_nof},
  {"e500v1.S32", C_e500v1_S32},
  {"e500v1.Snof", C_e500v1_Snof},
  {"e500v2.32", C_e500v2_32},
  {"e500v2.nof", C_e500v2_nof},
  {"e500v2.S32", C_e500v2_S32},
  {"e500v2.Snof", C_e500v2_Snof},
  {"e500mc.32", C_e500mc_32},
  {"e500mc.nof", C_e500mc_nof},
  {"e500mc.S32", C_e500mc_S32},
  {"e500mc.Snof", C_e500mc_Snof},
  {"e600.32", C_e600_32},
  {"e600.nof", C_e600_nof},
  {"e600.S32", C_e600_S32},
  {"e600.Snof", C_e600_Snof},
  {"e5500.32", C_e5500_32},
  {"e5500.64", C_e5500_64},
  {"e5500.nof", C_e5500_nof},
  {"e5500.S32", C_e5500_S32},
  {"e5500.S64", C_e5500_S64},
  {"e5500.Snof", C_e5500_Snof},
  {"e6500.32", C_e6500_32},
  {"e6500.64", C_e6500_64},
  {"e6500.nof", C_e6500_nof},
  {"e6500.S32", C_e6500_S32},
  {"e6500.S64", C_e6500_S64},
  {"e6500.Snof", C_e6500_Snof}
};

char *curr_system = NULL;
result **curr_res = NULL;
result **best_res = NULL;
result **ref_res = NULL;

database *all_db = NULL;

char *input_files[16];

static void
print_txt_corr (char *fname, result **res)
{
  FILE *f;
  int i, j;
  result *r;

  f = fopen (fname, "w");
  if (f == NULL) {
    fprintf (stderr, "[print_txt_corr] Could not write to file: %s\n", fname);
    exit (1);
  }

  fprintf (f, "                                   | c2 | c2 | c3 | c3 | c3 | c3 | v2 | v2 | v2 | v2 | mc | mc | mc | mc |e600|e600|e600|e600|5500|5500|5500|5500|5500|5500|6500|6500|6500|6500|6500|6500\n");
  fprintf (f, "                                   |nof |Snof| 32 |nof |S32 |Snof| 32 |nof |S32 |Snof| 32 |nof |S32 |Snof| 32 |nof |S32 |Snof| 32 | 64 |nof |S32 |S64 |Snof| 32 | 64 |nof |S32 |S64 |Snof\n");
  fprintf (f, "  Benchmark name                   |----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----\n");
  fprintf (f, "                                   |B C |B C |B C |B C |B C |B C |B C |B C |B C |B C |B C |B C |B C |B C |B C |B C |B C |B C |B C |B C |B C |B C |B C |B C |B C |B C |B C |B C |B C |B C \n");
  fprintf (f, "-----------------------------------+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----\n");
  for (j = 0; j < B_last; j++) {
    fprintf (f, "%-35s", bmk[j].name);
    for (i = 0; i < C_last; i++) {
      r = &(res[i][j]);
      fprintf (f, "|%c %c ", (r->f_comp)?'X':' ', (r->f_exec && r->f_val)?'X':' ');
    }
    fprintf (f, "\n");
    if ((j % 10) == 0)
      fprintf (f, "-----------------------------------+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----\n");
  }
  fprintf (f, "-----------------------------------+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----\n");
}

static void
print_txt_perf (FILE *f, result **r)
{
  /* TODO */
}

static void
print_html_corr (FILE *f, result **r)
{
  /* TODO */
}

static void
print_html_perf (FILE *f, result **r)
{
  /* TODO */
}

static void
print_diff_txt_corr (FILE *f, result **r1, result **r2)
{
  /* TODO */
}

static void
print_diff_txt_perf (FILE *f, result **r1, result **r2)
{
  /* TODO */
}

static void
print_diff_html_corr (FILE *f, result **r1, result **r2)
{
  /* TODO */
}

static void
print_diff_html_perf (FILE *f, result **r1, result **r2)
{
  /* TODO */
}

static void
load_db (char *dbname)
{
  FILE *f;
  database *db;
  char l[2048];
  int i, j;
  result *r;

  f = fopen (dbname, "r");
  if (f == NULL) {
    fprintf (stderr, "[laod_db] Cannot read from  %s\n", dbname);
    exit (1);
  }
  while (fgets (l, 2048, f) != NULL) {
    /* Allocate memory, link it to all_db */
    db = (database *)malloc (sizeof(database));
    db->res = (result **)malloc (sizeof(result *) * C_last);
    for (i = 0; i < C_last; i++)
      db->res[i] = (result *)malloc (sizeof(result) * B_last);
    db->next = all_db;
    all_db = db;
    /* Read system */
    l[strlen(l) - 1] = '\0';
    db->system = strdup (l);
    /* Read results */
    for (i = 0; i < C_last; i++)
      for (j = 0; j < B_last; j++) {
	fgets (l, 2048, f);
	r = &(db->res[i][j]);
	sscanf (l, "%d,%d,%d,%d,%f\n",
		&(r->f_comp), &(r->f_exec), &(r->f_val), &(r->f_iter), &(r->value));
      }
  }
  fclose (f);
}

static void
save_db (char *dbname)
{
  FILE *f;
  database *db;
  int i, j;
  result *r;

  f = fopen (dbname, "w");
  if (f == NULL) {
    fprintf (stderr, "[save_db] Cannot write to %s\n", dbname);
    exit (1);
  }
  for (db = all_db; db != NULL; db = db->next) {
    /* Write system */
    fprintf (f, "%s\n", db->system);
    /* Write results */
    for (i = 0; i < C_last; i++)
      for (j = 0; j < B_last; j++) {
	r = &(db->res[i][j]);
	fprintf (f, "%d,%d,%d,%d,%f\n",
		 r->f_comp, r->f_exec, r->f_val, r->f_iter, r->value);
      }
  }
  fclose (f);
}

static void
find_best_res (void)
{
  /* TODO */
}

static int
parse_bmk (char *s)
{
  int i;

  for (i=0; i < B_last; i++)
    if (strcmp (s, bmk[i].name) == 0) {
      return bmk[i].code;
    }
  fprintf (stderr, "Invalid BMK: %s\n", s);
  exit (1);
}

static int
parse_yes_no (char *s)
{
  int i;

  for (i=0; i < 2; i++)
    if (strcmp (s, yes_no[i].name) == 0) {
      return yes_no[i].code;
    }
  fprintf (stderr, "Invalid YES_NO: %s\n", s);
  exit (1);
}

static int
parse_core (char *s)
{
  int i;

  for (i=0; i < C_last; i++)
    if (strcmp (s, core[i].name) == 0) {
      return core[i].code;
    }
  fprintf (stderr, "Invalid CORE: %s\n", s);
  exit (1);
}

static double
parse_double (char *s)
{
  double d;
  int n;

  n = sscanf (s, "%f", &d);
  if (n == 0) {
    fprintf (stderr, "Invalid float number: %s\n", s);
    exit (1);
  }
}

static int curr_bmk;
static int curr_core;

static void
parse_token (char *s)
{
  double d;
  int i;

  if (strncmp (s, "BMK=", 4) == 0) {
    curr_bmk = parse_bmk (s+4);
  } else if (strncmp (s, "COMP=", 5) == 0) {
    i = parse_yes_no (s+5);
    curr_res[curr_core][curr_bmk].f_comp = i;
  } else if (strncmp (s, "EXEC=", 5) == 0) {
    i = parse_yes_no (s+5);
    curr_res[curr_core][curr_bmk].f_exec = i;
  } else if (strncmp (s, "VAL=", 4) == 0) {
    i = parse_yes_no (s+4);
    curr_res[curr_core][curr_bmk].f_val = i;
  } else if (strncmp (s, "TIME=", 5) == 0) {
    d = parse_double (s+5);
    curr_res[curr_core][curr_bmk].f_iter = 0;
    curr_res[curr_core][curr_bmk].value = d;
  } else if (strncmp (s, "ITER=", 5) == 0) {
    d = parse_double (s+5);
    curr_res[curr_core][curr_bmk].f_iter = 1;
    curr_res[curr_core][curr_bmk].value = d;
  } else if (strncmp (s, "SYSTEM=", 7) == 0) {
    if (curr_system == NULL)
      curr_system = strdup (s+7);
    else if (strcmp (curr_system, s+7) != 0) {
      fprintf (stderr, "[parse_token] Two systems in one single set of logs:\n%s\n%s\n",
	       curr_system, s+7);
      exit (1);
    }
  } else if (strncmp (s, "CORE=", 5) == 0) {
    curr_core = parse_core (s+5);
  } else {
    fprintf (stderr, "Invalid token: %s\n", s);
    exit (1);
  }
}

void
cmd_add (char *system)
{
  char **f, *s;
  FILE *fin;
  char line[2048];
  int i;

  /* Loop thorugh all files, all lines, all tokens */
  for (f=input_files; *f != NULL; f++) {
    fin = fopen (*f, "r");
    while (fgets (line, 2048, fin) != NULL) {
      s = strtok (line, " \n");
      while (s != NULL) {
	parse_token (s);
	s = strtok (NULL, " \n");
      }
    }    
    fclose (fin);
  }
}

int
main (int argc, char **argv)
{
  FILE *fin;
  char line[2048];
  char **f, *s;
  database *db;
  int i;

  /* TODO parse command line options
     del=<system>                          delete this db from database
     add=<system> <list of files>
         test each file
    fin = fopen (*f, "r");
    if (fin == NULL) {
      fprintf (stderr, "Could not open file: %s\n", f);
      exit (1);
    }
    fclose (fin);

         If system already on db, append / overwite it
            otherwise allocate memory for new results
    db = (database *)malloc (sizeof(database));
    db->res = (result **)malloc (sizeof(result *) * C_last);
    for (i = 0; i < C_last; i++)
      db->res[i] = (result *)malloc (sizeof(result) * B_last);
    db->next = all_db;
    all_db = db;
    curr_res = db->res;

         adds to db, and output four files
	 text x BC   test_report.<system>.corr.txt
	 text x perf test_report.<system>.perf.txt
	 html x BC   test_report.<system>.corr.html
	 html x perf test_report.<system>.perf.html
     comp=<system>=<system>                compare two systems eg: last x gold
     comp=<system>                         compare system with best of all
         both comp forms output four files:
	 text x BC   test_report.diff_#n.corr.txt
	 text x perf test_report.diff_#n.perf.txt
	 html x BC   test_report.diff_#n.corr.html
	 html x perf test_report.diff_#n.perf.html
  */               
  input_files[0] = argv[1];
  input_files[1] = argv[2];
  input_files[2] = NULL;

    db = (database *)malloc (sizeof(database));
    db->res = (result **)malloc (sizeof(result *) * C_last);
    for (i = 0; i < C_last; i++)
      db->res[i] = (result *)malloc (sizeof(result) * B_last);
    db->next = all_db;
    all_db = db;
    curr_res = db->res;
  
  cmd_add ("system");
  print_txt_corr ("test_report.system.corr.txt", curr_res);
}
