/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.examples.core;

import com.nxp.s32ds.ext.ide.examples.core.ExampleComponent;
import com.nxp.s32ds.ext.ide.examples.core.ExampleProjectLoader;
import com.nxp.s32ds.ext.ide.examples.core.IExampleComponent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class ExamplePropertyParser {
    public static final String META_FILE = "com.freescale.s32ds.cross.wizard.prefs";
    public static final String DESCRIPTION_FILE = "description.txt";
    public static final String GROUP_NAME_KEY = "groupName";
    public static final String SETTINGS_FOLDER = ".settings";
    public static final String WIZARD_VERSION_KEY = "wizardVersion";
    public static final String CORE_TYPE_KEY = "coreType";
    public static final String PROCESSOR = "processor";
    private static final String PLUGIN_ID = "com.nxp.s32ds.ext.ide.examples.core";

    public static IExampleComponent parseToModelObject(File projectFile, String groupFolder) throws CoreException {
        Path path = new Path(projectFile.getAbsolutePath());
        FileInputStream fileInput = null;
        ExampleComponent modelComponent = null;
        try {
            try {
                IProjectDescription projectDescription = ExampleProjectLoader.getProject((IPath)path, true);
                IPath removeLastSegments = path.removeLastSegments(1);
                String strPathMeta = String.valueOf(removeLastSegments.toOSString()) + '/' + SETTINGS_FOLDER + '/' + META_FILE;
                List<String> descr = ExamplePropertyParser.findDescription(removeLastSegments);
                modelComponent = new ExampleComponent();
                modelComponent.setProjectName(projectDescription.getName());
                modelComponent.setId(projectDescription.getName());
                String defGroup = ExamplePropertyParser.setGroupforProject(projectDescription.getName(), groupFolder);
                modelComponent.setGroup(defGroup);
                Path pathMeta = new Path(strPathMeta);
                if (pathMeta.toFile().exists()) {
                    Properties prop = new Properties();
                    fileInput = new FileInputStream(strPathMeta);
                    prop.load(fileInput);
                    modelComponent.setVersion(prop.getProperty(WIZARD_VERSION_KEY));
                    String propGroup = prop.getProperty(GROUP_NAME_KEY);
                    if (propGroup != null && !propGroup.isEmpty()) {
                        modelComponent.setId(propGroup);
                    }
                    modelComponent.setTarget(prop.getProperty(CORE_TYPE_KEY));
                }
                modelComponent.setRelatedProjects(projectDescription.getReferencedProjects());
                modelComponent.setLocation(projectFile.getAbsolutePath());
                modelComponent.setDescription(descr);
                if (!descr.isEmpty()) {
                    modelComponent.setShortComment(descr.get(0));
                }
            }
            catch (IOException | CoreException e) {
                Status status = new Status(4, PLUGIN_ID, e.getMessage(), e);
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            if (fileInput != null) {
                try {
                    fileInput.close();
                }
                catch (IOException e) {
                    Status status = new Status(4, PLUGIN_ID, e.getMessage(), (Throwable)e);
                    throw new CoreException((IStatus)status);
                }
            }
        }
        return modelComponent;
    }

    public static List<String> findDescription(IPath pathFile) throws CoreException {
        ArrayList<String> multiLineDescription = new ArrayList<String>();
        File descriptionFile = null;
        if (pathFile.toFile().exists()) {
            descriptionFile = ExamplePropertyParser.findDescritionFile(pathFile);
            if (descriptionFile == null) {
                IPath path = pathFile.removeLastSegments(1);
                descriptionFile = ExamplePropertyParser.findDescritionFile(path);
            }
            if (descriptionFile != null) {
                FileInputStream is = null;
                BufferedReader buf = null;
                try {
                    try {
                        is = new FileInputStream(descriptionFile);
                        buf = new BufferedReader(new InputStreamReader(is));
                        String line = buf.readLine();
                        while (line != null) {
                            multiLineDescription.add(line);
                            line = buf.readLine();
                        }
                    }
                    catch (IOException e) {
                        Status status = new Status(4, PLUGIN_ID, e.getMessage(), (Throwable)e);
                        throw new CoreException((IStatus)status);
                    }
                }
                finally {
                    try {
                        buf.close();
                        ((InputStream)is).close();
                    }
                    catch (IOException e) {
                        Status status = new Status(4, PLUGIN_ID, e.getMessage(), (Throwable)e);
                        throw new CoreException((IStatus)status);
                    }
                }
            }
        }
        return multiLineDescription;
    }

    private static File findDescritionFile(IPath pathFile) {
        File descriptionFile = null;
        File[] fileArray = pathFile.toFile().listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File iter = fileArray[n2];
            if (iter.getName().equals(DESCRIPTION_FILE)) {
                descriptionFile = iter;
                break;
            }
            ++n2;
        }
        return descriptionFile;
    }

    private static String setGroupforProject(String name, String folderName) {
        if (!folderName.isEmpty()) {
            return folderName;
        }
        return name;
    }
}

