/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cross.spt.explorer.internal.instructions;

import com.nxp.s32ds.cross.spt.explorer.internal.instructions.ISPTInstruction;
import com.nxp.s32ds.cross.spt.explorer.internal.instructions.ISPTInstructionGroup;
import com.nxp.s32ds.cross.spt.explorer.internal.instructions.ISPTInstructionParam;
import java.util.ArrayList;
import java.util.List;

public class SPTInstruction
implements ISPTInstruction {
    private final String name;
    protected List<ISPTInstructionParam> params;
    private ISPTInstructionGroup instructionGroup;
    private String documentation;

    public SPTInstruction(String name) {
        this.name = name;
        this.params = new ArrayList<ISPTInstructionParam>();
        this.createDocumentation();
    }

    public SPTInstruction(String name, ISPTInstructionGroup instructionGroup) {
        this(name);
        this.instructionGroup = instructionGroup;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<ISPTInstructionParam> getParams() {
        ArrayList<ISPTInstructionParam> result = new ArrayList<ISPTInstructionParam>();
        if (this.instructionGroup != null) {
            result.addAll(this.instructionGroup.getParams());
        }
        result.addAll(this.params);
        return result;
    }

    @Override
    public void addParam(ISPTInstructionParam param) {
        this.params.add(param);
    }

    @Override
    public String getSignature() {
        return this.name;
    }

    @Override
    public int compareTo(ISPTInstruction o) {
        return this.name.compareTo(o.getName());
    }

    @Override
    public ISPTInstructionGroup getGroup() {
        return this.instructionGroup;
    }

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    private void createDocumentation() {
        StringBuilder sb = new StringBuilder();
        sb.append('$').append('#');
        int i = 0;
        while (i < 60) {
            sb.append('=');
            ++i;
        }
        sb.append('\n');
        sb.append('$').append('#').append('\n');
        sb.append('$').append('#').append(' ').append(this.name).append(' ').append("instruction").append('\n');
        sb.append('$').append('#').append('\n');
        sb.append('$').append('#');
        i = 0;
        while (i < 60) {
            sb.append('=');
            ++i;
        }
        sb.append('\n');
        this.documentation = sb.toString();
    }
}

