/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.sptgen;

import com.nxp.s32ds.gte.gas.GasExternDirective;
import com.nxp.s32ds.gte.gas.GasGlobalDirective;
import com.nxp.s32ds.gte.gas.GasIncludeDirective;
import com.nxp.s32ds.gte.gas.GasLabel;
import com.nxp.s32ds.gte.gas.GasProgram;
import com.nxp.s32ds.gte.gas.GasSectionDirective;
import com.nxp.s32ds.gte.gas.GasStatement;
import com.nxp.s32ds.gte.gas.GasStatementContainer;
import com.nxp.s32ds.gte.gas.util.GasSwitch;
import com.nxp.s32ds.gte.sptprogram.SptEnumOperand;
import com.nxp.s32ds.gte.sptprogram.SptInstruction;
import com.nxp.s32ds.gte.sptprogram.SptLoopInstruction;
import com.nxp.s32ds.gte.sptprogram.SptOperand;
import com.nxp.s32ds.gte.sptprogram.SptProgramInstructions;
import com.nxp.s32ds.gte.sptprogram.SptStringOperand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EObject;

public class SptEmitter
extends GasSwitch<StringBuilder> {
    private final StringBuilder builder = new StringBuilder();
    private int level = 0;

    private void appendLine(String code) {
        if (this.level > 0) {
            int i = 0;
            while (i < this.level) {
                this.builder.append('\t');
                ++i;
            }
        }
        this.builder.append(code);
        this.builder.append('\n');
    }

    public StringBuilder caseGasStatementContainer(GasStatementContainer container) {
        GasStatement first;
        ++this.level;
        GasStatement successor = first = SptProgramInstructions.getFirstInChainOrNull((GasStatementContainer)container);
        while (successor != null) {
            if (successor instanceof SptLoopInstruction) {
                SptLoopInstruction loopInstruction = (SptLoopInstruction)successor;
                this.caseSptLoopInstruction(loopInstruction);
            } else if (successor instanceof SptInstruction) {
                SptInstruction instruction = (SptInstruction)successor;
                this.caseSptInstruction(instruction);
            } else {
                this.doSwitch((EObject)successor);
            }
            successor = successor.getSuccessor();
        }
        --this.level;
        return this.builder;
    }

    public StringBuilder caseGasExternDirective(GasExternDirective object) {
        this.generateComments((GasStatement)object);
        StringBuilder result = new StringBuilder();
        result.append(object.getName());
        result.append(' ');
        result.append(object.getSymbol());
        this.appendLine(result.toString());
        return this.builder;
    }

    public StringBuilder caseGasGlobalDirective(GasGlobalDirective object) {
        this.generateComments((GasStatement)object);
        StringBuilder result = new StringBuilder();
        result.append(object.getName());
        result.append(' ');
        result.append(object.getSymbol());
        this.appendLine(result.toString());
        return this.builder;
    }

    public StringBuilder caseGasIncludeDirective(GasIncludeDirective object) {
        this.generateComments((GasStatement)object);
        StringBuilder result = new StringBuilder();
        result.append(object.getName());
        result.append(' ');
        result.append('\"');
        result.append(object.getFileName());
        result.append('\"');
        this.appendLine(result.toString());
        return this.builder;
    }

    public StringBuilder caseGasLabel(GasLabel object) {
        int levelBackup = this.level;
        this.level = 0;
        this.generateComments((GasStatement)object);
        StringBuilder result = new StringBuilder();
        result.append(object.getSymbol());
        result.append(':');
        this.appendLine(result.toString());
        this.level = levelBackup;
        return this.builder;
    }

    public StringBuilder caseGasSectionDirective(GasSectionDirective object) {
        this.generateComments((GasStatement)object);
        StringBuilder result = new StringBuilder();
        result.append(object.getName());
        result.append(' ');
        result.append(object.getSectionName());
        this.appendLine(result.toString());
        return this.builder;
    }

    public StringBuilder caseGasProgram(GasProgram program) {
        this.appendLine("/* THIS IS GENERATED CODE - EDIT AT YOUR OWN RISKS */");
        this.generateComments(program);
        this.caseGasStatementContainer((GasStatementContainer)program);
        return this.builder;
    }

    public StringBuilder caseSptInstruction(SptInstruction object) {
        this.generateComments((GasStatement)object);
        StringBuilder code = new StringBuilder();
        String name = object.getName();
        code.append(name);
        EList operands = object.getOperands();
        for (SptOperand operand : operands) {
            code.append(' ');
            if (operand instanceof SptEnumOperand) {
                SptEnumOperand enumOperand = (SptEnumOperand)operand;
                Enumerator enumerator = enumOperand.getEnumeratorValue();
                String literal = enumerator.getName();
                String replaced = literal.replace("dot_", ".");
                code.append(replaced);
            } else if (operand instanceof SptStringOperand) {
                SptStringOperand stringOperand = (SptStringOperand)operand;
                String value = stringOperand.getStringValue().trim();
                code.append(value);
            }
            if (!operand.isNeedComma()) continue;
            code.append(',');
        }
        int lastPosition = code.length() - 1;
        char charAt = code.charAt(lastPosition);
        if (charAt == ',') {
            code.setLength(lastPosition);
        }
        this.appendLine(code.toString());
        return this.builder;
    }

    public StringBuilder caseSptLoopInstruction(SptLoopInstruction object) {
        this.caseSptInstruction((SptInstruction)object);
        this.caseGasStatementContainer((GasStatementContainer)object);
        this.appendLine("next");
        return this.builder;
    }

    private void generateComments(GasProgram object) {
        String label = object.getLabel();
        String comment = object.getComment();
        this.generateComments(label, comment);
    }

    private void generateComments(GasStatement object) {
        String label = object.getLabel();
        String comment = object.getComment();
        this.generateComments(label, comment);
    }

    private void generateComments(String label, String comment) {
        this.appendLine("#=========================================================================");
        if (label == null) {
            this.appendLine("#");
        } else {
            this.appendLine("#" + label);
        }
        if (comment == null) {
            this.appendLine("#");
        } else {
            String[] lines;
            String[] stringArray = lines = comment.split("\n");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                this.appendLine("#" + line);
                ++n2;
            }
        }
        this.appendLine("#=========================================================================");
    }

    public String generate(GasProgram program, IProgressMonitor monitor) {
        this.level = 0;
        this.builder.setLength(0);
        this.caseGasProgram(program);
        return this.builder.toString();
    }
}

