/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.core;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.cdt.embsysregview.Activator;
import org.eclipse.cdt.embsysregview.internal.model.TreeField;
import org.eclipse.jface.preference.IPreferenceStore;

public class SortingOrder {
    private static final Map<Integer, BitFieldSorter> stateMap = new LinkedHashMap<Integer, BitFieldSorter>();
    private static final int UNSORTED = 255;

    static {
        stateMap.put(0, new BitFieldSorter("Little Endian", true));
        stateMap.put(1, new BitFieldSorter("Big Endian", false));
        stateMap.put(255, new BitFieldSorter("unsorted", false));
    }

    private SortingOrder() {
    }

    public static void saveToPreference(int index) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        Iterator<Integer> it = stateMap.keySet().iterator();
        int code = 255;
        int next = 0;
        do {
            code = it.next();
            if (index == next) break;
            ++next;
        } while (it.hasNext());
        store.setValue("embsys_combosort", code);
    }

    public static BitFieldSorter getFromPreference() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        int key = store.getInt("embsys_combosort");
        if (stateMap.containsKey(key)) {
            return stateMap.get(key);
        }
        return SortingOrder.getDefaultSorter();
    }

    public static BitFieldSorter getDefaultSorter() {
        return stateMap.get(255);
    }

    public static Collection<BitFieldSorter> getSortersMap() {
        return stateMap.values();
    }

    public static class BitFieldSorter
    implements Comparator<TreeField> {
        private final String label;
        private final boolean isDescendant;

        private BitFieldSorter(String name, boolean direction) {
            this.label = name;
            this.isDescendant = direction;
        }

        @Override
        public int compare(TreeField o1, TreeField o2) {
            if (this.isDescendant) {
                return Integer.compare(o1.getBitOffset(), o2.getBitOffset());
            }
            return Integer.compare(o2.getBitOffset(), o1.getBitOffset());
        }

        public boolean isLittleEndian() {
            return this.isDescendant;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

