/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.vgt.ide.ui.viewers;

import com.nxp.s32ds.vgt.ide.internal.ui.VgtIdeUiActivator;
import com.nxp.s32ds.vgt.ide.internal.ui.viewers.ViewerMessages;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.osgi.util.NLS;

public class EnumeratorLabelProvider
extends AdapterFactoryLabelProvider {
    private static final String KEY_PATTERN = "_UI_{0}_{1}_literal";
    private String typeName;
    private ResourceLocator resourceLocator;

    public EnumeratorLabelProvider(AdapterFactory factory, EEnum eType, ResourceLocator locator) {
        super(factory);
        this.typeName = eType.getName();
        this.resourceLocator = locator;
    }

    public String getText(Object object) {
        if (object instanceof Enumerator) {
            Enumerator enumerator = (Enumerator)object;
            String name = enumerator.getName();
            String key = NLS.bind((String)KEY_PATTERN, (Object)this.typeName, (Object)name);
            try {
                String string = this.resourceLocator.getString(key);
                return string;
            }
            catch (Throwable t) {
                String message = NLS.bind((String)ViewerMessages.EnumeratorLabelProvider_e_get_text, (Object)key);
                VgtIdeUiActivator.log(message, t);
            }
        }
        return super.getText(object);
    }
}

