/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.internal.p2.engine.spi;

import com.nxp.s32ds.ext.rcp.internal.p2.engine.spi.Messages;
import com.nxp.s32ds.ext.rcp.internal.p2.engine.spi.Util;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;

public class ForcedRemoveAction
extends ProvisioningAction {
    public static final String ID = "remove";
    public static final String ACTION_REMOVE = "remove";

    public IStatus execute(Map<String, Object> parameters) {
        String path = (String)parameters.get("path");
        if (path == null) {
            return new Status(4, "com.nxp.s32ds.ext.rcp.p2.engine", 0, NLS.bind((String)Messages.param_not_set, (Object)"path", (Object)"remove"), null);
        }
        Location location = Platform.getConfigurationLocation();
        Location eclipse = Platform.getInstallLocation();
        if (location != null && eclipse != null) {
            try {
                IPath pathTemp = ForcedRemoveAction.getLocationIPath(location);
                IPath eclipsePath = ForcedRemoveAction.getLocationIPath(eclipse);
                if (!eclipsePath.isPrefixOf(pathTemp)) {
                    pathTemp = pathTemp.removeLastSegments(1);
                    pathTemp = pathTemp.addTrailingSeparator();
                    String firstString = eclipsePath.toString();
                    String secondString = pathTemp.toString();
                    path = path.replace("\\", "/");
                    path = path.replace(firstString, secondString);
                    Util.logWarning(String.format("%s is the new (USER) target parameter.%n", path));
                }
            }
            catch (URISyntaxException e) {
                Util.logWarning(e.getMessage());
                e.printStackTrace();
            }
        } else {
            Util.logError(String.format("FAIL to compute/validate/re-create target parameter.%n", new Object[0]));
            return Status.CANCEL_STATUS;
        }
        File file = new File(path);
        try {
            ForcedRemoveAction.delete(file);
            return Status.OK_STATUS;
        }
        catch (IOException e) {
            e.printStackTrace();
            return Status.CANCEL_STATUS;
        }
    }

    public static void delete(File dir) throws IOException {
        if (dir.isDirectory()) {
            if (dir.list().length == 0) {
                dir.delete();
            } else {
                String[] files;
                String[] stringArray = files = dir.list();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    String temp = stringArray[n2];
                    File fileDelete = new File(dir, temp);
                    ForcedRemoveAction.delete(fileDelete);
                    ++n2;
                }
                if (dir.list().length == 0) {
                    dir.delete();
                }
            }
        } else {
            dir.delete();
        }
    }

    public IStatus undo(Map<String, Object> parameters) {
        return Status.OK_STATUS;
    }

    private static IPath getLocationIPath(Location loc) throws URISyntaxException {
        URI locationURI = null;
        IPath path = null;
        try {
            locationURI = loc.getURL().toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            String filePath = loc.getURL().getFile();
            File tempFile = new File(filePath);
            locationURI = tempFile.toURI();
        }
        if (locationURI != null) {
            path = URIUtil.toPath((URI)locationURI);
            return path;
        }
        Util.logWarning(String.format("Cannot obtain the proper locationURI value in getLocationIPath function. %n", new Object[0]));
        path = new Path(loc.getURL().getPath());
        if (path != null) {
            Util.logWarning(String.format("Use this [%s] path instead.%n", path.toString()));
        }
        return path;
    }
}

