/*****************************************************************************/
/* FILE NAME: ghsvle.ld   Copyright (c) 2016-2017 Freescale Semiconductor, Inc.  */
/*                        Copyright (c) 2017 NXP                             */
/*                                                       All Rights Reserved */
/* DESCRIPTION:                                                              */
/* Compiler: GHS                                                             */
/*****************************************************************************/

DEFAULTS {
/* define heap and stack size */
__HEAP_SIZE            = 0x1000;
__STACK_SIZE           = 0x1000;

SRAM_SIZE =  $(RAM_LENGTH)K;    
/* Define SRAM Base Address */
SRAM_BASE_ADDR = $(RAM_START);
  
/* Define CPU$(CORE_ID) Local Instruction SRAM Allocation */  
LOCALIMEM_SIZE = 16K;
/* Define CPU$(CORE_ID) Local Instruction SRAM Base Address */
LOCALIMEM_BASE_ADDR = $(LOCALIMEM_START);

/* Define CPU$(CORE_ID) Local Data SRAM Allocation */
LOCALDMEM_SIZE = 32K;
/* Define CPU$(CORE_ID) Local Data SRAM Base Address */
LOCALDMEM_BASE_ADDR = $(LOCALDMEM_START);
}
        
MEMORY
{

    flash_rchw : org = $(BOOT_HEADER_BLOCK),   len = 0x4
    cpu0_reset_vec : org = $(BOOT_HEADER_BLOCK)+0x10,   len = 0x4
    cpu1_reset_vec : org = $(BOOT_HEADER_BLOCK)+0x14,   len = 0x4
        
    internal_flash     : org = $(FLASH_START), len = $(FLASH_LENGTH)K 
    internal_ram       : org = SRAM_BASE_ADDR, len = SRAM_SIZE         
    stack_ram   : org = (LOCALDMEM_BASE_ADDR + LOCALDMEM_SIZE - __STACK_SIZE)  len = __STACK_SIZE
        
    local_imem  : org = LOCALIMEM_BASE_ADDR,   len = LOCALIMEM_SIZE
    local_dmem  : org = LOCALDMEM_BASE_ADDR,   len = LOCALDMEM_SIZE - __STACK_SIZE      
}

SECTIONS
{
    .rchw LOAD (ADDR(flash_rchw)): {} > flash_rchw

    .cpu0_reset_vector  LOAD (ADDR(cpu0_reset_vec)) : 
    {
        KEEP(*(.cpu0_reset_vector))
    } > cpu0_reset_vec

    .cpu1_reset_vector  LOAD (ADDR(cpu1_reset_vec)): 
    {
        KEEP(*(.cpu1_reset_vector))
    } > cpu1_reset_vec

    .startup  ALIGN(0x400):
    {
        __start = . ;
        *(.startup)
    } > internal_flash

    .core_exceptions_table ALIGN(0x1000): {KEEP(*(.core_exceptions_table))} > . /* Exception Vector Table (IVPR) - align 4K boundary */        
    .intc_vector_table ALIGN(0x1000): {KEEP(*(.intc_vector_table ))} > .     /* ISR Vector Table - must be 4K aligned */        
            
    .init : {} > .
    .init_vle: {*(.init) *(.init_vle)} > .            
    .text : {} > .                         /* BookE Code */
    .vletext : {} > .                      /* VLE Code */ 
    .fixaddr : {} > .                      /* Required for         */
    .fixtype : {} > .                      /* compatibility with   */
    .secinfo : {} > .                      /* GHS provided startup */
    .syscall : {} > .                      /* code                 */
    
    __argv=.;
    __env=.;

    .rodata  : {*(.rdata) *(.rodata)} > .  /* Read Only Data */
    .ctors  ALIGN (0x4): { *(.ctors) } > .
    .dtors  ALIGN (0x4): { *(.dtors) } > .
    extab : {} > .
    extabindex : {} > .
    .sdata2 : {} > .                       /* Small Initialised Constant Data */
    .sbss2 :  {} > .                       /* Small Uninitialised Data (Area2) */

    . = ALIGN(0x8);
    _ROMADDR = .;

    __DATA_ROM = _ROMADDR;
    __DATA_ROM_ADDR = __DATA_ROM;

__DATA_RAM=.;
    .data  LOAD (__DATA_ROM): { *(.data)  } > internal_ram                       /* Initialised Data */
__DATA_END=.;

__SDATA_RAM=.;        
    .sdata  LOAD ((ADDR(.sdata) - ADDR(.data)) + __DATA_ROM): { *(.sdata)  } > . /* Small Initialised Data (Area1) */
__SDATA_END=.;

__BSS_START=.;
    .sbss : { *(.sbss) } > . /* Small Uninitialised Data (Area1) */
    .bss : { *(.bss) } > .   /* Uninitialised Data               */
__BSS_END=.;

    .heap   ALIGN(16) PAD(__HEAP_SIZE)       : {} > .             /* Heap Area  */
    .stack  ALIGN(4)  PAD(__STACK_SIZE)      : {} > stack_ram     /* Stack Area */

__SP_INIT      = ADDR(stack_ram) + SIZEOF(stack_ram); 

__DATA_SRAM_ADDR  = ADDR(.data);
__DATA_SIZE  = __DATA_END - __DATA_SRAM_ADDR;
__SDATA_SIZE = __SDATA_END - __SDATA_RAM;
__BSS_SIZE   = __BSS_END - __BSS_START;
  
/* Labels Used for Initialising SRAM ECC */
__SRAM_SIZE = SRAM_SIZE;

__SDATA_ROM_ADDR  = __DATA_ROM_ADDR + __DATA_SIZE;
__SDATA_SRAM_ADDR = __SDATA_RAM;
__SRAM_BASE_ADDR = SRAM_BASE_ADDR;
      
__LOCAL_DMEM_SIZE = LOCALDMEM_SIZE;
__LOCAL_DMEM_BASE_ADDR = LOCALDMEM_BASE_ADDR;

__LOCAL_IMEM_SIZE = LOCALIMEM_SIZE;
__LOCAL_IMEM_BASE_ADDR = LOCALIMEM_BASE_ADDR;
}





