/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.internal.p2.engine.spi;

import com.nxp.s32ds.ext.rcp.internal.p2.engine.spi.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Util {
    public static void logError(String message) {
        Util.log(4, message);
    }

    public static void logError(String message, Throwable t) {
        Util.log(4, message, t);
    }

    public static void logWarning(String message) {
        Util.log(2, message);
    }

    public static void log(int status, String message, Throwable t) {
        LogHelper.log((IStatus)Util.createMessage(status, message, t));
    }

    public static void log(int status, String message) {
        LogHelper.log((IStatus)Util.createMessage(status, message));
    }

    public static IStatus createErrorMessage(String message) {
        return new Status(4, "org.eclipse.equinox.p2.repository", message);
    }

    public static IStatus createMessage(int status, String message, Throwable t) {
        return new Status(status, "org.eclipse.equinox.p2.repository", message, t);
    }

    public static IStatus createMessage(int status, String message) {
        return new Status(status, "org.eclipse.equinox.p2.repository", message);
    }

    public static String getInstallFolder(IProfile profile) {
        return profile.getProperty("org.eclipse.equinox.p2.installFolder");
    }

    private static IAgentLocation getAgentLocation(IProvisioningAgent agent) {
        return (IAgentLocation)agent.getService(IAgentLocation.SERVICE_NAME);
    }

    public static IArtifactRepositoryManager getArtifactRepositoryManager(IProvisioningAgent agent) {
        return (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
    }

    public static IFileArtifactRepository getDownloadCacheRepo(IProvisioningAgent agent) throws ProvisionException {
        IArtifactRepository repository;
        URI location = Util.getDownloadCacheLocation(agent);
        if (location == null) {
            throw new IllegalStateException(Messages.could_not_obtain_download_cache);
        }
        IArtifactRepositoryManager manager = Util.getArtifactRepositoryManager(agent);
        if (manager == null) {
            throw new IllegalStateException(Messages.artifact_repo_not_found);
        }
        try {
            repository = manager.loadRepository(location, null);
        }
        catch (ProvisionException provisionException) {
            String repositoryName = location + " - Agent download cache";
            HashMap<String, String> properties = new HashMap<String, String>(1);
            properties.put("p2.system", Boolean.TRUE.toString());
            repository = manager.createRepository(location, repositoryName, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
        }
        IFileArtifactRepository downloadCache = (IFileArtifactRepository)repository.getAdapter(IFileArtifactRepository.class);
        if (downloadCache == null) {
            throw new ProvisionException(NLS.bind((String)Messages.download_cache_not_writeable, (Object)location));
        }
        return downloadCache;
    }

    private static URI getDownloadCacheLocation(IProvisioningAgent agent) {
        IAgentLocation location = Util.getAgentLocation(agent);
        if (location == null) {
            return null;
        }
        return URIUtil.append((URI)location.getDataArea("org.eclipse.equinox.p2.core"), (String)"cache/");
    }

    public static int copyStream(InputStream in, boolean closeIn, OutputStream out, boolean closeOut) throws IOException {
        try {
            int len;
            int written = 0;
            byte[] buffer = new byte[16384];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
                written += len;
            }
            int n = written;
            return n;
        }
        finally {
            try {
                if (closeIn) {
                    in.close();
                }
            }
            finally {
                if (closeOut) {
                    out.close();
                }
            }
        }
    }

    public static int copyFile(File srcFile, File destFile) throws IOException {
        return Util.copyStream(new FileInputStream(srcFile), true, new FileOutputStream(destFile), true);
    }

    public static int apendStream(InputStream extra, boolean closeExtra, OutputStream base, boolean closeBase) throws IOException {
        try {
            int len;
            int written = 0;
            byte[] buffer = new byte[16384];
            while ((len = extra.read(buffer)) != -1) {
                base.write(buffer, 0, len);
                written += len;
            }
            int n = written;
            return n;
        }
        finally {
            try {
                if (closeExtra) {
                    extra.close();
                }
            }
            finally {
                if (closeBase) {
                    base.close();
                }
            }
        }
    }

    public int removeElement(File base, String element) {
        block3: {
            try {
                if (base.exists()) {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document doc = builder.parse(base);
                    TransformerFactory tFactory = TransformerFactory.newInstance();
                    Transformer tFormer = tFactory.newTransformer();
                    Element remElement = (Element)doc.getElementsByTagName(element).item(0);
                    remElement.getParentNode().removeChild(remElement);
                    doc.normalize();
                    DOMSource source = new DOMSource(doc);
                    StreamResult dest = new StreamResult(base);
                    tFormer.transform(source, dest);
                    break block3;
                }
                return 2;
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return 1;
    }

    public static String getTempFolder() {
        String tmpdir = System.getProperty("java.io.tmpdir");
        if (!tmpdir.endsWith("/") && !tmpdir.endsWith("\\")) {
            tmpdir = String.valueOf(tmpdir) + File.separator;
        }
        return tmpdir;
    }

    public static int mergeXMLFiles(File baseXML, File extraXML) {
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transFormer = transFactory.newTransformer();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document baseDoc = builder.parse(baseXML);
            Document extraDoc = builder.parse(extraXML);
            Element baseRoot = baseDoc.getDocumentElement();
            Element extraRoot = extraDoc.getDocumentElement();
            Util.mergeNodes(baseRoot, extraRoot);
            baseDoc.normalize();
            DOMSource source = new DOMSource(baseDoc);
            StreamResult dest = new StreamResult(baseXML);
            transFormer.transform(source, dest);
        }
        catch (Exception exception) {
            return 0;
        }
        return 1;
    }

    private static void mergeNodes(Node baseRoot, Node extraRoot) {
        NodeList baseChildList = baseRoot.getChildNodes();
        NodeList extraChildList = extraRoot.getChildNodes();
        int len = baseChildList.getLength() >= extraChildList.getLength() ? extraChildList.getLength() : baseChildList.getLength();
        int i = 0;
        while (i < len) {
            if (baseChildList.item(i).getNodeName().equals(extraChildList.item(i).getNodeName())) {
                Util.mergeNodes(baseChildList.item(i), extraChildList.item(i));
            } else {
                Document baseDoc = baseRoot.getOwnerDocument();
                Node migratingChild = extraChildList.item(i);
                migratingChild = baseDoc.importNode(migratingChild, true);
                baseRoot.appendChild(migratingChild);
            }
            ++i;
        }
    }

    public static String getExtension(File fileIn) {
        int dotIdx = fileIn.getAbsolutePath().lastIndexOf(".");
        return fileIn.getAbsolutePath().substring(dotIdx + 1);
    }
}

