/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.emf.ecore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class EObjects {
    public static <T extends EObject> List<T> extractList(ResourceSet resourceSet, Class<T> typeObject) {
        if (resourceSet == null) {
            return Collections.emptyList();
        }
        EList resources = resourceSet.getResources();
        ArrayList<T> list = new ArrayList<T>();
        for (Resource resource : resources) {
            List<T> found = EObjects.extractList(resource, typeObject);
            list.addAll(found);
        }
        return list;
    }

    public static <T extends EObject> List<T> extractList(Resource resource, Class<T> typeObject) {
        if (resource == null) {
            return Collections.emptyList();
        }
        EList contents = resource.getContents();
        return EObjects.extractList((Collection<? extends EObject>)contents, typeObject);
    }

    public static <T extends EObject> List<T> extractList(Collection<? extends EObject> contents, Class<T> typeObject) {
        if (contents == null) {
            return Collections.emptyList();
        }
        ArrayList<EObject> list = new ArrayList<EObject>();
        for (EObject eObject : contents) {
            if (!typeObject.isAssignableFrom(eObject.getClass())) continue;
            EObject cast = (EObject)typeObject.cast(eObject);
            list.add(cast);
        }
        return list;
    }

    public static <T extends EObject> T firstOrNull(ResourceSet resourceSet, Class<T> typeObject) {
        if (resourceSet == null) {
            return null;
        }
        EList resources = resourceSet.getResources();
        for (Resource resource : resources) {
            T found = EObjects.firstOrNull(resource, typeObject);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public static <T extends EObject> T firstOrNull(Resource resource, Class<T> typeObject) {
        if (resource == null) {
            return null;
        }
        EList contents = resource.getContents();
        return EObjects.firstOrNull((Collection<? extends EObject>)contents, typeObject);
    }

    public static <T extends EObject> T firstOrNull(Collection<? extends EObject> contents, Class<T> typeObject) {
        if (contents == null) {
            return null;
        }
        for (EObject eObject : contents) {
            if (!typeObject.isAssignableFrom(eObject.getClass())) continue;
            return (T)((EObject)typeObject.cast(eObject));
        }
        return null;
    }

    public static String proposeNextValue(EList<? extends EObject> list, EStructuralFeature feature, String prefix) {
        if (!feature.getEType().equals(EcorePackage.Literals.ESTRING)) {
            throw new IllegalArgumentException("Feature type should be 'String'");
        }
        return list.size() <= 100 ? EObjects.proposeNextValue100AndLess(list, feature, prefix) : EObjects.proposeNextValueAbove100(list, feature, prefix);
    }

    private static String proposeNextValue100AndLess(EList<? extends EObject> list, EStructuralFeature feature, String prefix) {
        String newName = prefix;
        ArrayList<String> names = new ArrayList<String>();
        for (EObject eObject : list) {
            Object object = eObject.eGet(feature);
            if (object == null) continue;
            names.add((String)object);
        }
        int i = 0;
        while (i < 100) {
            newName = String.valueOf(prefix) + "_" + i;
            if (!names.contains(newName)) {
                return newName;
            }
            ++i;
        }
        return newName;
    }

    private static String proposeNextValueAbove100(EList<? extends EObject> list, EStructuralFeature feature, String prefix) {
        String newName = prefix;
        long maxIndex = -1L;
        for (EObject eObject : list) {
            String featureValue;
            Object object = eObject.eGet(feature);
            if (object == null || !(featureValue = (String)object).matches(String.valueOf(prefix) + "_\\d+")) continue;
            String strIndex = featureValue.replaceAll("\\D+", "");
            try {
                long index = Long.valueOf(strIndex);
                maxIndex = Math.max(index, maxIndex);
            }
            catch (NumberFormatException numberFormatException) {
                return prefix;
            }
        }
        newName = maxIndex >= 0L ? String.valueOf(prefix) + "_" + (maxIndex + 1L) : String.valueOf(prefix) + "_0";
        return newName;
    }
}

