/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.internal.ui.view;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.miginfocom.swt.MigLayout;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.embsysregview.Activator;
import org.eclipse.cdt.embsysregview.Messages;
import org.eclipse.cdt.embsysregview.core.EmbSysRegCore;
import org.eclipse.cdt.embsysregview.core.EmbSysRegEngine;
import org.eclipse.cdt.embsysregview.internal.model.TreeElement;
import org.eclipse.cdt.embsysregview.internal.model.TreeField;
import org.eclipse.cdt.embsysregview.internal.model.TreeParent;
import org.eclipse.cdt.embsysregview.internal.model.TreeRegister;
import org.eclipse.cdt.embsysregview.internal.model.TreeRegisterGroup;
import org.eclipse.cdt.embsysregview.internal.ui.view.BinaryButtonsCellEditor;
import org.eclipse.cdt.embsysregview.internal.ui.view.EmbSysRegUi;
import org.eclipse.cdt.embsysregview.internal.ui.view.HexCellEditorValidator;
import org.eclipse.cdt.embsysregview.internal.ui.view.HexColumnEditingSupport;
import org.eclipse.cdt.embsysregview.internal.utils.GUIUtils;
import org.eclipse.cdt.embsysregview.internal.utils.Timer;
import org.eclipse.cdt.embsysregview.properties.PropertiesHolder;
import org.eclipse.cdt.embsysregview.views.EmbSysRegView;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class EmbSysRegViewer {
    private static final int TABLE_UPDATE_INTERVAL = 200;
    private TreeViewer m_viewer;
    private Composite header;
    private Label infoLabel;
    private Composite m_parent = null;
    private final EmbSysRegEngine m_engine;
    private Timer m_updateTimer;
    private final EmbSysRegView.RegSet kind;
    private static final QualifiedName EMBSYS_REGVIEW_STATE = new QualifiedName(null, "EmbSysTreeViewState");
    private static final QualifiedName SPR_REGVIEW_STATE = new QualifiedName(null, "SprTreeViewState");
    private static final QualifiedName ALL_REGVIEW_STATE = new QualifiedName(null, "AllTreeViewState");
    private static final String EMPTY = "";
    private static final String ARCH_TXT = "Arch: ";
    private static final String VEND_TXT = "  Vendor: ";
    private static final String CHIP_TXT = "  Chip: ";
    private static final String CORE_TXT = "  Core: ";
    private static final String BOARD_TXT = "  Board: ";

    public EmbSysRegViewer(EmbSysRegView embSysRegView, Composite parent, EmbSysRegView.RegSet regSet) {
        this.m_parent = parent;
        this.kind = regSet;
        this.m_engine = new EmbSysRegEngine(this, regSet);
        this.init();
    }

    public void requestUpdate() {
        GUIUtils.exec(new Runnable(){

            @Override
            public void run() {
                EmbSysRegViewer.this.m_updateTimer.start();
            }
        });
    }

    private void addExpandCollapseGroupListeners() {
        Tree tree = this.m_viewer.getTree();
        tree.addListener(41, new Listener(){

            public void handleEvent(Event event) {
            }
        });
        tree.addListener(17, new Listener(){

            public void handleEvent(Event event) {
                Widget item = event.item;
                Object obj = item.getData();
                if (obj instanceof TreeRegisterGroup) {
                    TreeRegisterGroup treeRegisterGroup = (TreeRegisterGroup)obj;
                    treeRegisterGroup.setExpanded(true);
                }
            }
        });
        tree.addListener(18, new Listener(){

            public void handleEvent(Event event) {
                Widget item = event.item;
                Object obj = item.getData();
                if (obj instanceof TreeRegisterGroup) {
                    TreeRegisterGroup treeRegisterGroup = (TreeRegisterGroup)obj;
                    treeRegisterGroup.setExpanded(false);
                }
            }
        });
    }

    private void init() {
        this.m_parent.setLayout((Layout)new MigLayout("fill", EMPTY, EMPTY));
        this.header = new Composite(this.m_parent, 0);
        this.header.setLayoutData((Object)"dock north,height 16px,width 100%,wmin 0,hmin 16,gap 1 1 -5 1");
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.marginLeft = 1;
        rowLayout.marginRight = 0;
        rowLayout.marginTop = -1;
        rowLayout.marginBottom = 0;
        rowLayout.fill = true;
        rowLayout.wrap = false;
        rowLayout.spacing = 5;
        this.header.setLayout((Layout)rowLayout);
        this.infoLabel = new Label(this.header, 64);
        this.m_viewer = this.m_engine.createTreeViewer(this.m_parent);
        HexCellEditor textCellEditor = new HexCellEditor(this.m_viewer.getTree());
        textCellEditor.setValidator(new HexCellEditorValidator(this.m_viewer));
        AutoDropComboBoxViewerCellEditor comboBoxCellEditor = new AutoDropComboBoxViewerCellEditor((Composite)this.m_viewer.getTree());
        TreeViewerColumn column = new TreeViewerColumn(this.m_viewer, 0);
        column.getColumn().setWidth(250);
        column.getColumn().setMoveable(false);
        column.getColumn().setText("Register");
        ColumnLabelProvider registerColumnLabelProvider = EmbSysRegUi.getRegisterColumnLabelProvider(this.m_parent);
        column.setLabelProvider((CellLabelProvider)registerColumnLabelProvider);
        column = new TreeViewerColumn(this.m_viewer, 0);
        column.getColumn().setWidth(80);
        column.getColumn().setMoveable(false);
        column.getColumn().setText("Hex");
        ColumnLabelProvider hexColumnLabelProvider = EmbSysRegUi.getHexColumnLabelProvider(this.m_parent);
        column.setLabelProvider((CellLabelProvider)hexColumnLabelProvider);
        HexColumnEditingSupport hexColumnEditingSupport = this.getHexColumnEditingSupport(comboBoxCellEditor, textCellEditor);
        column.setEditingSupport((EditingSupport)hexColumnEditingSupport);
        column = new TreeViewerColumn(this.m_viewer, 0);
        column.getColumn().setWidth(200);
        column.getColumn().setMoveable(false);
        column.getColumn().setText("Bin");
        ColumnLabelProvider binColumnLabelProvider = EmbSysRegUi.getBinColumnLabelProvider(this.m_parent);
        column.setLabelProvider((CellLabelProvider)binColumnLabelProvider);
        EditingSupport binEditingSupport = this.getBinEditingSupport();
        column.setEditingSupport(binEditingSupport);
        comboBoxCellEditor.setValidator(new HexCellEditorValidator(this.m_viewer));
        ICellEditorListener cellEditorListener = this.getCellEditorListener(comboBoxCellEditor, hexColumnEditingSupport.getCurrentEditedElement());
        comboBoxCellEditor.addListener(cellEditorListener);
        column = new TreeViewerColumn(this.m_viewer, 0);
        column.getColumn().setWidth(80);
        column.getColumn().setMoveable(false);
        column.getColumn().setText("Reset");
        ColumnLabelProvider resetColumnLabelProvider = EmbSysRegUi.getResetColumnLabelProvider();
        column.setLabelProvider((CellLabelProvider)resetColumnLabelProvider);
        column = new TreeViewerColumn(this.m_viewer, 0);
        column.getColumn().setAlignment(0x1000000);
        column.getColumn().setWidth(50);
        column.getColumn().setMoveable(false);
        column.getColumn().setText("Access");
        ColumnLabelProvider accessColumnLabelProvider = EmbSysRegUi.getAccessColumnLabelProvider();
        column.setLabelProvider((CellLabelProvider)accessColumnLabelProvider);
        if (this.kind.embsys) {
            column = new TreeViewerColumn(this.m_viewer, 0);
            column.getColumn().setWidth(80);
            column.getColumn().setMoveable(false);
            column.getColumn().setText("Address");
            column.setLabelProvider((CellLabelProvider)EmbSysRegUi.getAddressColumnLabelProvider());
        }
        column = new TreeViewerColumn(this.m_viewer, 0);
        column.getColumn().setWidth(300);
        column.getColumn().setMoveable(false);
        column.getColumn().setText("Description");
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.m_viewer);
        CellLabelProvider descriptionCellLabelProvider = EmbSysRegUi.getDescriptionCellLabelProvider();
        column.setLabelProvider(descriptionCellLabelProvider);
        this.m_viewer.getTree().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent event) {
                EmbSysRegViewer.this.handleDoubleClick(event);
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseUp(MouseEvent arg0) {
            }
        });
        this.m_updateTimer = new Timer(200){

            @Override
            public void run() {
                EmbSysRegViewer.this.update();
            }
        };
        this.m_updateTimer.setRepeating(false);
        this.m_updateTimer.start();
        this.addExpandCollapseGroupListeners();
    }

    protected void update() {
        if (!this.m_viewer.getControl().isDisposed()) {
            this.m_viewer.refresh();
        }
    }

    protected void handleDoubleClick(MouseEvent event) {
        Tree tree = (Tree)event.getSource();
        Point point = new Point(event.x, event.y);
        int selectedColumn = -1;
        TreeItem item = null;
        int i = 0;
        while (i < tree.getColumnCount()) {
            item = tree.getItem(point);
            if (item != null && item.getBounds(i).contains(point)) {
                selectedColumn = i;
                break;
            }
            ++i;
        }
        if (selectedColumn == 0 && item != null) {
            Object obj = item.getData();
            if (obj instanceof TreeElement && !TreeElement.isModelAccessGranted()) {
                if (obj instanceof TreeRegisterGroup) {
                    this.m_engine.toggleSelectedGroupOff((TreeRegisterGroup)obj);
                } else if (obj instanceof TreeRegister) {
                    this.m_engine.toggleSelectedRegisterOff((TreeRegister)obj);
                }
                this.m_engine.getEmbSysRegViewer().requestUpdate();
                return;
            }
            if (obj instanceof TreeRegisterGroup) {
                TreeRegisterGroup treeGroup = (TreeRegisterGroup)obj;
                this.m_engine.toggleSelectGroup(treeGroup);
            }
            if (obj instanceof TreeRegister) {
                TreeRegister treeRegister = (TreeRegister)obj;
                this.m_engine.toggleOnLineState(treeRegister);
            }
            if (obj instanceof TreeField) {
                TreeField treeField = (TreeField)obj;
                TreeRegister treeRegister = (TreeRegister)treeField.getParent();
                treeRegister.isWriteOnly();
            }
        }
    }

    public IStatus updateView(IProject newProject) {
        IContentProvider contentProvider = this.m_viewer.getContentProvider();
        if (contentProvider != null) {
            contentProvider.inputChanged((Viewer)this.m_viewer, null, (Object)newProject);
            this.m_engine.updateDebugContext();
        }
        if (this.m_viewer.getControl().isDisposed()) {
            return new Status(1, "org.eclipse.cdt.embsysregview", Messages.EmbSysRegViewer_disposed);
        }
        this.m_viewer.setInput((Object)this.m_engine.getModel().getRoot());
        if (newProject != null) {
            HashSet<String> expandedPaths = null;
            try {
                Object objs = newProject.getSessionProperty(this.getTreeViewStateQualifier());
                expandedPaths = objs != null ? (HashSet<String>)objs : new HashSet<String>();
            }
            catch (CoreException e) {
                return new Status(4, "org.eclipse.cdt.embsysregview", Messages.EmbSysRegViewer_cannot_get_property, (Throwable)e);
            }
            TreeItem[] treeItemArray = this.m_viewer.getTree().getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem treeItem = treeItemArray[n2];
                this.expandTreeItems(treeItem, expandedPaths);
                ++n2;
            }
        }
        this.requestUpdate();
        return Status.OK_STATUS;
    }

    private void expandTreeItems(TreeItem treeItem, Set<String> paths) {
        TreeElement node = (TreeElement)treeItem.getData();
        if (node == null) {
            return;
        }
        if (paths.contains(node.getPath())) {
            this.m_viewer.setExpandedState((Object)node, true);
            this.m_viewer.refresh((Object)node, true);
        }
        TreeItem[] treeItemArray = treeItem.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            this.expandTreeItems(child, paths);
            ++n2;
        }
    }

    public IStatus saveState(IProject oldProject) {
        if (this.m_viewer.getControl().isDisposed()) {
            return new Status(1, "org.eclipse.cdt.embsysregview", Messages.EmbSysRegViewer_disposed);
        }
        if (oldProject != null) {
            HashSet<String> expandedPaths = new HashSet<String>();
            Object[] objectArray = this.m_viewer.getExpandedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                TreeParent expandedNode = (TreeParent)obj;
                expandedPaths.add(expandedNode.getPath());
                ++n2;
            }
            if (!expandedPaths.isEmpty()) {
                try {
                    oldProject.setSessionProperty(this.getTreeViewStateQualifier(), expandedPaths);
                }
                catch (CoreException e) {
                    return new Status(4, "org.eclipse.cdt.embsysregview", Messages.EmbSysRegViewer_cannot_set_property, (Throwable)e);
                }
            }
        }
        return Status.OK_STATUS;
    }

    private HexColumnEditingSupport getHexColumnEditingSupport(ComboBoxViewerCellEditor comboBoxCellEditor, TextCellEditor textCellEditor) {
        return new HexColumnEditingSupport(this.m_viewer, comboBoxCellEditor, textCellEditor, this.m_engine);
    }

    private ICellEditorListener getCellEditorListener(final ComboBoxViewerCellEditor comboBoxCellEditor, final TreeElement element) {
        return new ICellEditorListener(){

            public void applyEditorValue() {
                int selectionIndex = ((CCombo)comboBoxCellEditor.getControl()).getSelectionIndex();
                TreeElement obj = element;
                if (obj instanceof TreeField) {
                    TreeField registerField = (TreeField)obj;
                    long value = -1L;
                    if (selectionIndex != -1) {
                        value = registerField.getInterpretations().getValue(((CCombo)comboBoxCellEditor.getControl()).getItem(selectionIndex));
                    } else {
                        String svalue = ((CCombo)comboBoxCellEditor.getControl()).getText();
                        if (svalue.startsWith("0x")) {
                            value = Long.valueOf(svalue.substring(2, svalue.length()), 16);
                        }
                    }
                    if (value != -1L) {
                        EmbSysRegViewer.this.m_engine.updateRegisterByField(registerField, value);
                    }
                }
            }

            public void cancelEditor() {
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }
        };
    }

    private EditingSupport getBinEditingSupport() {
        return new EditingSupport((ColumnViewer)this.m_viewer){

            protected boolean canEdit(Object element) {
                return EmbSysRegCore.checkEditRules(element);
            }

            protected CellEditor getCellEditor(Object element) {
                return new BinaryButtonsCellEditor(EmbSysRegViewer.this.m_viewer.getTree(), EmbSysRegViewer.this.m_engine);
            }

            protected Object getValue(Object element) {
                return element;
            }

            protected void setValue(Object element, Object value) {
                EmbSysRegViewer.this.m_viewer.refresh(element);
            }
        };
    }

    public void updateInfoLabel() {
        String infoBanner;
        if (this.infoLabel.isDisposed()) {
            return;
        }
        IProject project = this.m_engine.getModel().getProject();
        if (project == null) {
            this.setInfoLabel(Messages.EmbSysRegViewer_No_project_selected);
            return;
        }
        try {
            if (!project.isNatureEnabled("org.eclipse.cdt.core.cnature")) {
                this.setInfoLabel(String.valueOf(String.format(Messages.EmbSysRegViewer_project, project.getName())) + Messages.EmbSysRegViewer_non_c_project);
                return;
            }
        }
        catch (CoreException e) {
            this.setInfoLabel(String.format(Messages.EmbSysRegViewer_project_does_not_exist_or_closed, project.getName()));
            Activator.log(e.getStatus());
            return;
        }
        Map<String, String> props = PropertiesHolder.getInstance(project).getValueMap();
        String storedArchitecture = props.get("architecture");
        String storedVendor = props.get("vendor");
        String storedChip = props.get("chip");
        String storedBoard = props.get("board");
        String storedCore = props.get("core");
        String projectTitle = String.format(Messages.EmbSysRegViewer_project, project.getName());
        String string = infoBanner = TreeParent.isModelAccessGranted() ? Messages.EmbSysRegViewer_click_to_read : Messages.EmbSysRegViewer_select_context;
        if (this.m_engine.isEmpty() || storedArchitecture == null || storedVendor == null || storedChip == null) {
            this.setInfoLabel(String.valueOf(projectTitle) + Messages.EmbSysRegViewer_select_chip);
        } else if (storedBoard == null || storedBoard.equals(EMPTY)) {
            this.setInfoLabel(String.valueOf(projectTitle) + ARCH_TXT + storedArchitecture + VEND_TXT + storedVendor + CHIP_TXT + storedChip + infoBanner);
        } else if (this.kind.spr) {
            this.setInfoLabel(String.valueOf(projectTitle) + ARCH_TXT + storedArchitecture + VEND_TXT + storedVendor + CHIP_TXT + storedChip + CORE_TXT + storedCore + infoBanner);
        } else {
            this.setInfoLabel(String.valueOf(projectTitle) + ARCH_TXT + storedArchitecture + VEND_TXT + storedVendor + CHIP_TXT + storedChip + BOARD_TXT + storedBoard + infoBanner);
        }
    }

    private void setInfoLabel(String s) {
        this.infoLabel.setText(s);
        this.infoLabel.setToolTipText(s);
        this.infoLabel.pack();
    }

    public boolean setFocus() {
        boolean result = false;
        if (this.m_viewer != null) {
            this.m_viewer.getControl().setFocus();
        }
        return result;
    }

    public void setReadOnly(boolean contextFlag, boolean sessionFlag) {
        this.getEngine().getModel().setRootReadOnly(contextFlag);
        this.getEngine().getModel().cleanList(sessionFlag);
        this.updateInfoLabel();
        this.requestUpdate();
    }

    public ISelectionProvider getViewer() {
        return this.m_viewer;
    }

    public EmbSysRegEngine getEngine() {
        return this.m_engine;
    }

    public void setTrackingSession(DsfSession session) {
        this.getEngine().setSessionTrack(session);
    }

    private QualifiedName getTreeViewStateQualifier() {
        switch (this.kind) {
            case EMBSYS: {
                return EMBSYS_REGVIEW_STATE;
            }
            case SPR: {
                return SPR_REGVIEW_STATE;
            }
        }
        return ALL_REGVIEW_STATE;
    }

    protected static class AutoDropComboBoxViewerCellEditor
    extends ComboBoxViewerCellEditor {
        public AutoDropComboBoxViewerCellEditor(Composite parent) {
            super(parent, 0);
            this.setActivationStyle(1);
        }

        protected Control createControl(Composite parent) {
            Control control = super.createControl(parent);
            CCombo cCombo = super.getViewer().getCCombo();
            cCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!((CCombo)this.getControl()).getListVisible()) {
                        this.focusLost();
                    }
                }
            });
            return control;
        }
    }

    protected static class HexCellEditor
    extends TextCellEditor {
        public HexCellEditor(Tree tree) {
            super((Composite)tree);
        }

        protected void focusLost() {
            if (this.isActivated()) {
                this.fireCancelEditor();
            }
        }
    }
}

